/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fortelauncher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.fordiac.ide.fortelauncher.Messages;
import org.eclipse.fordiac.ide.runtime.RuntimeLaunchTab;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.widget.DirectoryChooserControl;
import org.eclipse.fordiac.ide.ui.widget.FileChooserControl;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ForteLaunchTab
extends RuntimeLaunchTab {
    private static final String DEFAULT_FORTE_PORT = "61499";
    private static final String ATTR_FORTE_PORT = "org.eclipse.fordiac.ide.fortelauncher.port";
    private static final String ATTR_FORTE_ARGUMENTS = "org.eclipse.fordiac.ide.fortelauncher.arguments";
    private FileChooserControl forteChooser;
    private DirectoryChooserControl workingDirChooser;
    private Text argumentsField;

    public void createControl(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)parent);
        Composite comp = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(comp);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)comp);
        this.setControl((Control)comp);
        this.forteChooser = new FileChooserControl(comp, 0, Messages.FortePreferencePage_FORTELocation, true);
        this.forteChooser.addChooserValueChangedListener(newVal -> this.scheduleUpdateJob());
        this.workingDirChooser = new DirectoryChooserControl(comp, 0, Messages.ForteLaunchTab_WorkingDirectory, true);
        this.workingDirChooser.addChooserValueChangedListener(newVal -> this.scheduleUpdateJob());
        this.createPortSelection(comp);
        this.createArguments(comp);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.fordiac.ide.fortelauncher");
        String fortePath = store.getString("pathPreference");
        if (fortePath != null && !fortePath.isBlank()) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", fortePath);
        } else {
            configuration.removeAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION");
        }
        configuration.setAttribute(ATTR_FORTE_PORT, DEFAULT_FORTE_PORT);
        configuration.removeAttribute(ATTR_FORTE_ARGUMENTS);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.forteChooser.setValue(configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", ""));
            this.workingDirChooser.setValue(configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", ""));
            this.setPortValue(configuration.getAttribute(ATTR_FORTE_PORT, DEFAULT_FORTE_PORT));
            this.argumentsField.setText(configuration.getAttribute(ATTR_FORTE_ARGUMENTS, ""));
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", this.forteChooser.getValue());
        String workingDir = this.workingDirChooser.getValue();
        if (!workingDir.isBlank()) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", workingDir);
        }
        configuration.setAttribute(ATTR_FORTE_PORT, this.getPortValue());
        configuration.setAttribute(ATTR_FORTE_ARGUMENTS, this.argumentsField.getText());
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", "-c localhost:" + this.getPortValue() + " " + this.argumentsField.getText());
    }

    public String getName() {
        return Messages.ForteLaunchTab_TabTitle;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (!super.isValid(launchConfig)) {
            return false;
        }
        if (this.forteChooser.getValue().isBlank()) {
            this.setErrorMessage(Messages.ForteLaunchTabError_No4diacFORTEExecutableSet);
            return false;
        }
        return true;
    }

    private void createArguments(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.FortePreferencePage_Arguments);
        this.argumentsField = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 2).applyTo((Control)this.argumentsField);
        this.argumentsField.addModifyListener(ev -> this.scheduleUpdateJob());
    }
}

