/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.math.BigInteger;
import org.eclipse.fordiac.ide.model.data.WordType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyBitValue;
import org.eclipse.fordiac.ide.model.value.NumericValueConverter;

public final class WordValue
implements AnyBitValue {
    public static final WordValue DEFAULT = new WordValue(0);
    private final short value;

    private WordValue(short value) {
        this.value = value;
    }

    public static WordValue toWordValue(short value) {
        return new WordValue(value);
    }

    public static WordValue toWordValue(Number value) {
        return new WordValue(value.shortValue());
    }

    public static WordValue toWordValue(String value) {
        return WordValue.toWordValue((Number)NumericValueConverter.INSTANCE_WORD.toValue(value));
    }

    public static WordValue toWordValue(AnyBitValue value) {
        return WordValue.toWordValue(value.shortValue());
    }

    public WordType getType() {
        return IecTypes.ElementaryTypes.WORD;
    }

    @Override
    public boolean boolValue() {
        return this.value != 0;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)Short.toUnsignedInt(this.value);
    }

    @Override
    public int intValue() {
        return Short.toUnsignedInt(this.value);
    }

    @Override
    public long longValue() {
        return Short.toUnsignedLong(this.value);
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    public int hashCode() {
        return Short.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WordValue other = (WordValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return NumericValueConverter.INSTANCE_WORD.toString((Object)this.intValue());
    }
}

