/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug;

import java.util.Collection;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorMonitor;
import org.eclipse.fordiac.ide.model.eval.EvaluatorThreadPoolExecutor;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;

public class EvaluatorStreamMonitor
implements IFlushableStreamMonitor,
EvaluatorMonitor {
    private final Set<IStreamListener> listeners = ConcurrentHashMap.newKeySet();
    private final Queue<String> messageBuffer = new ConcurrentLinkedQueue<String>();
    private boolean buffered = true;
    private final boolean error;

    public EvaluatorStreamMonitor(boolean error) {
        this.error = error;
    }

    public String getContents() {
        return this.messageBuffer.stream().collect(Collectors.joining("\n"));
    }

    public void flushContents() {
        this.messageBuffer.clear();
    }

    public void setBuffered(boolean buffer) {
        this.buffered = buffer;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void addListener(IStreamListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IStreamListener listener) {
        this.listeners.remove(listener);
    }

    protected void message(String message) {
        if (this.buffered) {
            this.messageBuffer.add(message);
        }
        this.listeners.forEach(l -> l.streamAppended(message, (IStreamMonitor)this));
    }

    public void info(String message) {
        if (!this.error) {
            this.message(message + "\n");
        }
    }

    public void warn(String message) {
        if (this.error) {
            this.message(message + "\n");
        }
    }

    public void error(String message) {
        if (this.error) {
            this.message(message + "\n");
        }
    }

    public void error(String message, Throwable t) {
        if (this.error) {
            this.message(message + ": " + String.valueOf(t) + "\n");
        }
    }

    public void update(Collection<? extends Variable<?>> variables, Evaluator evaluator) {
    }

    public void terminated(EvaluatorThreadPoolExecutor executor) {
    }
}

