/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.impl.NamedElementAnnotations;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;

final class LibraryElementAnnotations {
    static void setDocumentation(LibraryElement type, String value) {
        type.setAttribute("Documentation", IecTypes.HelperTypes.CDATA, value, null);
    }

    static String getDocumentation(LibraryElement type) {
        Attribute attribute = type.getAttribute("Documentation");
        return attribute != null ? attribute.getValue() : "";
    }

    public static boolean validateName(LibraryElement element, DiagnosticChain diagnostics, Map<Object, Object> context) {
        TypeEntry entry;
        String fileName;
        boolean isValid = true;
        if (element.eContainer() == null && element.getTypeEntry() != null && element.getTypeEntry().getFile() != null && !(fileName = TypeEntry.getTypeNameFromFile((entry = element.getTypeEntry()).getFile())).equals(entry.getTypeName())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 25, MessageFormat.format(Messages.IdentifierVerifier_NotMatchingWithFilename, entry.getTypeName(), entry.getFile().getName()), FordiacMarkerHelper.getDiagnosticData((EObject)element, (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, new String[0])));
            }
            isValid = false;
        }
        return NamedElementAnnotations.validateName(element, diagnostics, context) && isValid;
    }

    private LibraryElementAnnotations() {
        throw new UnsupportedOperationException("Helper class must not be instantiated");
    }
}

