/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.AddressSpaceFileTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.NamespaceMetadataType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.IdType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class NamespaceMetadataTypeNode
extends BaseObjectTypeNode
implements NamespaceMetadataType {
    public NamespaceMetadataTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public String getNamespaceUri() throws UaException {
        PropertyTypeNode node = this.getNamespaceUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setNamespaceUri(String namespaceUri) throws UaException {
        PropertyTypeNode node = this.getNamespaceUriNode();
        node.setValue(new Variant((Object)namespaceUri));
    }

    @Override
    public String readNamespaceUri() throws UaException {
        try {
            return this.readNamespaceUriAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeNamespaceUri(String namespaceUri) throws UaException {
        try {
            this.writeNamespaceUriAsync(namespaceUri).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readNamespaceUriAsync() {
        return ((CompletableFuture)this.getNamespaceUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNamespaceUriAsync(String namespaceUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)namespaceUri));
        return this.getNamespaceUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNamespaceUriNode() throws UaException {
        try {
            return this.getNamespaceUriNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNamespaceUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NamespaceUri", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getNamespaceVersion() throws UaException {
        PropertyTypeNode node = this.getNamespaceVersionNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setNamespaceVersion(String namespaceVersion) throws UaException {
        PropertyTypeNode node = this.getNamespaceVersionNode();
        node.setValue(new Variant((Object)namespaceVersion));
    }

    @Override
    public String readNamespaceVersion() throws UaException {
        try {
            return this.readNamespaceVersionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeNamespaceVersion(String namespaceVersion) throws UaException {
        try {
            this.writeNamespaceVersionAsync(namespaceVersion).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readNamespaceVersionAsync() {
        return ((CompletableFuture)this.getNamespaceVersionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNamespaceVersionAsync(String namespaceVersion) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)namespaceVersion));
        return this.getNamespaceVersionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNamespaceVersionNode() throws UaException {
        try {
            return this.getNamespaceVersionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNamespaceVersionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NamespaceVersion", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DateTime getNamespacePublicationDate() throws UaException {
        PropertyTypeNode node = this.getNamespacePublicationDateNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setNamespacePublicationDate(DateTime namespacePublicationDate) throws UaException {
        PropertyTypeNode node = this.getNamespacePublicationDateNode();
        node.setValue(new Variant((Object)namespacePublicationDate));
    }

    @Override
    public DateTime readNamespacePublicationDate() throws UaException {
        try {
            return this.readNamespacePublicationDateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeNamespacePublicationDate(DateTime namespacePublicationDate) throws UaException {
        try {
            this.writeNamespacePublicationDateAsync(namespacePublicationDate).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readNamespacePublicationDateAsync() {
        return ((CompletableFuture)this.getNamespacePublicationDateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNamespacePublicationDateAsync(DateTime namespacePublicationDate) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)namespacePublicationDate));
        return this.getNamespacePublicationDateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNamespacePublicationDateNode() throws UaException {
        try {
            return this.getNamespacePublicationDateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNamespacePublicationDateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NamespacePublicationDate", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getIsNamespaceSubset() throws UaException {
        PropertyTypeNode node = this.getIsNamespaceSubsetNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setIsNamespaceSubset(Boolean isNamespaceSubset) throws UaException {
        PropertyTypeNode node = this.getIsNamespaceSubsetNode();
        node.setValue(new Variant((Object)isNamespaceSubset));
    }

    @Override
    public Boolean readIsNamespaceSubset() throws UaException {
        try {
            return this.readIsNamespaceSubsetAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeIsNamespaceSubset(Boolean isNamespaceSubset) throws UaException {
        try {
            this.writeIsNamespaceSubsetAsync(isNamespaceSubset).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readIsNamespaceSubsetAsync() {
        return ((CompletableFuture)this.getIsNamespaceSubsetNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeIsNamespaceSubsetAsync(Boolean isNamespaceSubset) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)isNamespaceSubset));
        return this.getIsNamespaceSubsetNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getIsNamespaceSubsetNode() throws UaException {
        try {
            return this.getIsNamespaceSubsetNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getIsNamespaceSubsetNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "IsNamespaceSubset", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public IdType[] getStaticNodeIdTypes() throws UaException {
        PropertyTypeNode node = this.getStaticNodeIdTypesNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer[]) {
            Integer[] values = (Integer[])value;
            IdType[] staticNodeIdTypes = new IdType[values.length];
            for (int i = 0; i < values.length; ++i) {
                staticNodeIdTypes[i] = IdType.from((int)values[i]);
            }
            return staticNodeIdTypes;
        }
        if (value instanceof IdType[]) {
            return (IdType[])value;
        }
        return null;
    }

    @Override
    public void setStaticNodeIdTypes(IdType[] staticNodeIdTypes) throws UaException {
        PropertyTypeNode node = this.getStaticNodeIdTypesNode();
        node.setValue(new Variant((Object)staticNodeIdTypes));
    }

    @Override
    public IdType[] readStaticNodeIdTypes() throws UaException {
        try {
            return this.readStaticNodeIdTypesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeStaticNodeIdTypes(IdType[] staticNodeIdTypes) throws UaException {
        try {
            this.writeStaticNodeIdTypesAsync(staticNodeIdTypes).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends IdType[]> readStaticNodeIdTypesAsync() {
        return ((CompletableFuture)this.getStaticNodeIdTypesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer[]) {
                Integer[] values = (Integer[])value;
                IdType[] staticNodeIdTypes = new IdType[values.length];
                for (int i = 0; i < values.length; ++i) {
                    staticNodeIdTypes[i] = IdType.from((int)values[i]);
                }
                return staticNodeIdTypes;
            }
            if (value instanceof IdType[]) {
                return (IdType[])value;
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeStaticNodeIdTypesAsync(IdType[] staticNodeIdTypes) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)staticNodeIdTypes));
        return this.getStaticNodeIdTypesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getStaticNodeIdTypesNode() throws UaException {
        try {
            return this.getStaticNodeIdTypesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getStaticNodeIdTypesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "StaticNodeIdTypes", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String[] getStaticNumericNodeIdRange() throws UaException {
        PropertyTypeNode node = this.getStaticNumericNodeIdRangeNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setStaticNumericNodeIdRange(String[] staticNumericNodeIdRange) throws UaException {
        PropertyTypeNode node = this.getStaticNumericNodeIdRangeNode();
        node.setValue(new Variant((Object)staticNumericNodeIdRange));
    }

    @Override
    public String[] readStaticNumericNodeIdRange() throws UaException {
        try {
            return this.readStaticNumericNodeIdRangeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeStaticNumericNodeIdRange(String[] staticNumericNodeIdRange) throws UaException {
        try {
            this.writeStaticNumericNodeIdRangeAsync(staticNumericNodeIdRange).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readStaticNumericNodeIdRangeAsync() {
        return ((CompletableFuture)this.getStaticNumericNodeIdRangeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeStaticNumericNodeIdRangeAsync(String[] staticNumericNodeIdRange) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)staticNumericNodeIdRange));
        return this.getStaticNumericNodeIdRangeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getStaticNumericNodeIdRangeNode() throws UaException {
        try {
            return this.getStaticNumericNodeIdRangeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getStaticNumericNodeIdRangeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "StaticNumericNodeIdRange", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getStaticStringNodeIdPattern() throws UaException {
        PropertyTypeNode node = this.getStaticStringNodeIdPatternNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setStaticStringNodeIdPattern(String staticStringNodeIdPattern) throws UaException {
        PropertyTypeNode node = this.getStaticStringNodeIdPatternNode();
        node.setValue(new Variant((Object)staticStringNodeIdPattern));
    }

    @Override
    public String readStaticStringNodeIdPattern() throws UaException {
        try {
            return this.readStaticStringNodeIdPatternAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeStaticStringNodeIdPattern(String staticStringNodeIdPattern) throws UaException {
        try {
            this.writeStaticStringNodeIdPatternAsync(staticStringNodeIdPattern).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readStaticStringNodeIdPatternAsync() {
        return ((CompletableFuture)this.getStaticStringNodeIdPatternNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeStaticStringNodeIdPatternAsync(String staticStringNodeIdPattern) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)staticStringNodeIdPattern));
        return this.getStaticStringNodeIdPatternNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getStaticStringNodeIdPatternNode() throws UaException {
        try {
            return this.getStaticStringNodeIdPatternNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getStaticStringNodeIdPatternNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "StaticStringNodeIdPattern", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public AddressSpaceFileTypeNode getNamespaceFileNode() throws UaException {
        try {
            return this.getNamespaceFileNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends AddressSpaceFileTypeNode> getNamespaceFileNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NamespaceFile", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (AddressSpaceFileTypeNode)node);
    }
}

