/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.polyomino.structures;

import org.eclipse.elk.alg.common.polyomino.structures.IThreeValueGrid;

public class TwoBitGrid
implements IThreeValueGrid {
    private static final long LSB_MASK = 1L;
    private static final long TWO_LSBS_MASK = 3L;
    private static final long EMPTY = 0L;
    private static final long BLOCKED = 1L;
    private static final long WEAKLY_BLOCKED = 2L;
    private static final double HALF_WORD = 32.0;
    private static final int REST_MASK = 31;
    private static final int RIGHT_SHIFT = 5;
    private long[][] grid;
    private int xSize;
    private int ySize;

    TwoBitGrid() {
        this(0, 0);
    }

    public TwoBitGrid(int width, int height) {
        this.grid = new long[height][(int)Math.ceil((double)width / 32.0)];
        this.xSize = width;
        this.ySize = height;
    }

    @Override
    public int getWidth() {
        return this.xSize;
    }

    @Override
    public int getHeight() {
        return this.ySize;
    }

    @Override
    public boolean isEmpty(int x, int y) throws IndexOutOfBoundsException {
        try {
            return this.retrieve(x, y) == 0L;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Grid is only of size " + this.xSize + "*" + this.ySize + ". Requested point (" + x + ", " + y + ") is out of bounds.");
        }
    }

    @Override
    public boolean isBlocked(int x, int y) throws IndexOutOfBoundsException {
        try {
            return this.retrieve(x, y) == 1L;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Grid is only of size " + this.xSize + "*" + this.ySize + ". Requested point (" + x + ", " + y + ") is out of bounds.");
        }
    }

    @Override
    public boolean isWeaklyBlocked(int x, int y) throws IndexOutOfBoundsException {
        try {
            return this.retrieve(x, y) == 2L;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Grid is only of size " + this.xSize + "*" + this.ySize + ". Requested point (" + x + ", " + y + ") is out of bounds.");
        }
    }

    @Override
    public boolean inBounds(int x, int y) {
        return x >= 0 && y >= 0 && x < this.xSize && y < this.ySize;
    }

    @Override
    public void reinitialize(int width, int height) {
        this.grid = new long[height][(int)Math.ceil((double)width / 32.0)];
        this.xSize = width;
        this.ySize = height;
    }

    @Override
    public void setEmpty(int x, int y) throws IndexOutOfBoundsException {
        this.set(x, y, false, false);
    }

    @Override
    public void setBlocked(int x, int y) throws IndexOutOfBoundsException {
        this.set(x, y, false, true);
    }

    @Override
    public void setWeaklyBlocked(int x, int y) throws IndexOutOfBoundsException {
        this.set(x, y, true, false);
    }

    public String toString() {
        Object output = " ";
        Integer count = 0;
        int x = 0;
        while (x < this.xSize) {
            output = (String)output + count.toString();
            count = this.incModTen(count);
            ++x;
        }
        output = (String)output + "\n";
        count = 0;
        int y = 0;
        while (y < this.ySize) {
            output = (String)output + count.toString();
            count = this.incModTen(count);
            int x2 = 0;
            while (x2 < this.xSize) {
                long item = this.retrieve(x2, y);
                output = item == 0L ? (String)output + "_" : (item == 1L ? (String)output + "X" : (String)output + "0");
                ++x2;
            }
            output = (String)output + "\n";
            ++y;
        }
        return ((String)output).substring(0, ((String)output).length() - 1);
    }

    private long retrieve(int x, int y) throws ArrayIndexOutOfBoundsException {
        int xWord = x >> 5;
        long xRest = x & 0x1F;
        long value = this.grid[y][xWord] >>> (int)(xRest << 1) & 3L;
        return value;
    }

    private void set(int x, int y, boolean msb, boolean lsb) throws IndexOutOfBoundsException {
        try {
            if (x >= this.xSize) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int xWord = x >> 5;
            long xRest = x & 0x1F;
            long mask = 1L << (int)(xRest << 1);
            this.grid[y][xWord] = lsb ? this.grid[y][xWord] | mask : this.grid[y][xWord] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            this.grid[y][xWord] = msb ? this.grid[y][xWord] | mask : this.grid[y][xWord] & ((mask <<= 1) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Grid is only of size " + this.xSize + "*" + this.ySize + ". Requested point (" + x + ", " + y + ") is out of bounds.");
        }
    }

    private int incModTen(int num) {
        int eight = 8;
        if (num > 8) {
            return 0;
        }
        return num + 1;
    }
}

