/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.variables.SessionSecurityDiagnosticsType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class SessionSecurityDiagnosticsTypeNode
extends BaseDataVariableTypeNode
implements SessionSecurityDiagnosticsType {
    public SessionSecurityDiagnosticsTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public NodeId getSessionId() throws UaException {
        BaseDataVariableTypeNode node = this.getSessionIdNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setSessionId(NodeId sessionId) throws UaException {
        BaseDataVariableTypeNode node = this.getSessionIdNode();
        node.setValue(new Variant((Object)sessionId));
    }

    @Override
    public NodeId readSessionId() throws UaException {
        try {
            return this.readSessionIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSessionId(NodeId sessionId) throws UaException {
        try {
            this.writeSessionIdAsync(sessionId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readSessionIdAsync() {
        return ((CompletableFuture)this.getSessionIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSessionIdAsync(NodeId sessionId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)sessionId));
        return this.getSessionIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSessionIdNode() throws UaException {
        try {
            return this.getSessionIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSessionIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SessionId", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getClientUserIdOfSession() throws UaException {
        BaseDataVariableTypeNode node = this.getClientUserIdOfSessionNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setClientUserIdOfSession(String clientUserIdOfSession) throws UaException {
        BaseDataVariableTypeNode node = this.getClientUserIdOfSessionNode();
        node.setValue(new Variant((Object)clientUserIdOfSession));
    }

    @Override
    public String readClientUserIdOfSession() throws UaException {
        try {
            return this.readClientUserIdOfSessionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClientUserIdOfSession(String clientUserIdOfSession) throws UaException {
        try {
            this.writeClientUserIdOfSessionAsync(clientUserIdOfSession).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readClientUserIdOfSessionAsync() {
        return ((CompletableFuture)this.getClientUserIdOfSessionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeClientUserIdOfSessionAsync(String clientUserIdOfSession) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)clientUserIdOfSession));
        return this.getClientUserIdOfSessionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getClientUserIdOfSessionNode() throws UaException {
        try {
            return this.getClientUserIdOfSessionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getClientUserIdOfSessionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ClientUserIdOfSession", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String[] getClientUserIdHistory() throws UaException {
        BaseDataVariableTypeNode node = this.getClientUserIdHistoryNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setClientUserIdHistory(String[] clientUserIdHistory) throws UaException {
        BaseDataVariableTypeNode node = this.getClientUserIdHistoryNode();
        node.setValue(new Variant((Object)clientUserIdHistory));
    }

    @Override
    public String[] readClientUserIdHistory() throws UaException {
        try {
            return this.readClientUserIdHistoryAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClientUserIdHistory(String[] clientUserIdHistory) throws UaException {
        try {
            this.writeClientUserIdHistoryAsync(clientUserIdHistory).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readClientUserIdHistoryAsync() {
        return ((CompletableFuture)this.getClientUserIdHistoryNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeClientUserIdHistoryAsync(String[] clientUserIdHistory) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)clientUserIdHistory));
        return this.getClientUserIdHistoryNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getClientUserIdHistoryNode() throws UaException {
        try {
            return this.getClientUserIdHistoryNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getClientUserIdHistoryNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ClientUserIdHistory", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getAuthenticationMechanism() throws UaException {
        BaseDataVariableTypeNode node = this.getAuthenticationMechanismNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setAuthenticationMechanism(String authenticationMechanism) throws UaException {
        BaseDataVariableTypeNode node = this.getAuthenticationMechanismNode();
        node.setValue(new Variant((Object)authenticationMechanism));
    }

    @Override
    public String readAuthenticationMechanism() throws UaException {
        try {
            return this.readAuthenticationMechanismAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAuthenticationMechanism(String authenticationMechanism) throws UaException {
        try {
            this.writeAuthenticationMechanismAsync(authenticationMechanism).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readAuthenticationMechanismAsync() {
        return ((CompletableFuture)this.getAuthenticationMechanismNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeAuthenticationMechanismAsync(String authenticationMechanism) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)authenticationMechanism));
        return this.getAuthenticationMechanismNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getAuthenticationMechanismNode() throws UaException {
        try {
            return this.getAuthenticationMechanismNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getAuthenticationMechanismNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AuthenticationMechanism", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getEncoding() throws UaException {
        BaseDataVariableTypeNode node = this.getEncodingNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setEncoding(String encoding) throws UaException {
        BaseDataVariableTypeNode node = this.getEncodingNode();
        node.setValue(new Variant((Object)encoding));
    }

    @Override
    public String readEncoding() throws UaException {
        try {
            return this.readEncodingAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEncoding(String encoding) throws UaException {
        try {
            this.writeEncodingAsync(encoding).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readEncodingAsync() {
        return ((CompletableFuture)this.getEncodingNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEncodingAsync(String encoding) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoding));
        return this.getEncodingNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getEncodingNode() throws UaException {
        try {
            return this.getEncodingNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getEncodingNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Encoding", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getTransportProtocol() throws UaException {
        BaseDataVariableTypeNode node = this.getTransportProtocolNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setTransportProtocol(String transportProtocol) throws UaException {
        BaseDataVariableTypeNode node = this.getTransportProtocolNode();
        node.setValue(new Variant((Object)transportProtocol));
    }

    @Override
    public String readTransportProtocol() throws UaException {
        try {
            return this.readTransportProtocolAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTransportProtocol(String transportProtocol) throws UaException {
        try {
            this.writeTransportProtocolAsync(transportProtocol).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readTransportProtocolAsync() {
        return ((CompletableFuture)this.getTransportProtocolNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeTransportProtocolAsync(String transportProtocol) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)transportProtocol));
        return this.getTransportProtocolNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getTransportProtocolNode() throws UaException {
        try {
            return this.getTransportProtocolNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getTransportProtocolNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TransportProtocol", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public MessageSecurityMode getSecurityMode() throws UaException {
        BaseDataVariableTypeNode node = this.getSecurityModeNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return MessageSecurityMode.from((int)((Integer)value));
        }
        if (value instanceof MessageSecurityMode) {
            return (MessageSecurityMode)value;
        }
        return null;
    }

    @Override
    public void setSecurityMode(MessageSecurityMode securityMode) throws UaException {
        BaseDataVariableTypeNode node = this.getSecurityModeNode();
        node.setValue(new Variant((Object)securityMode));
    }

    @Override
    public MessageSecurityMode readSecurityMode() throws UaException {
        try {
            return this.readSecurityModeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSecurityMode(MessageSecurityMode securityMode) throws UaException {
        try {
            this.writeSecurityModeAsync(securityMode).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends MessageSecurityMode> readSecurityModeAsync() {
        return ((CompletableFuture)this.getSecurityModeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return MessageSecurityMode.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeSecurityModeAsync(MessageSecurityMode securityMode) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)securityMode));
        return this.getSecurityModeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSecurityModeNode() throws UaException {
        try {
            return this.getSecurityModeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSecurityModeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecurityMode", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getSecurityPolicyUri() throws UaException {
        BaseDataVariableTypeNode node = this.getSecurityPolicyUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSecurityPolicyUri(String securityPolicyUri) throws UaException {
        BaseDataVariableTypeNode node = this.getSecurityPolicyUriNode();
        node.setValue(new Variant((Object)securityPolicyUri));
    }

    @Override
    public String readSecurityPolicyUri() throws UaException {
        try {
            return this.readSecurityPolicyUriAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSecurityPolicyUri(String securityPolicyUri) throws UaException {
        try {
            this.writeSecurityPolicyUriAsync(securityPolicyUri).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readSecurityPolicyUriAsync() {
        return ((CompletableFuture)this.getSecurityPolicyUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSecurityPolicyUriAsync(String securityPolicyUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)securityPolicyUri));
        return this.getSecurityPolicyUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSecurityPolicyUriNode() throws UaException {
        try {
            return this.getSecurityPolicyUriNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSecurityPolicyUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecurityPolicyUri", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ByteString getClientCertificate() throws UaException {
        BaseDataVariableTypeNode node = this.getClientCertificateNode();
        return (ByteString)node.getValue().getValue().getValue();
    }

    @Override
    public void setClientCertificate(ByteString clientCertificate) throws UaException {
        BaseDataVariableTypeNode node = this.getClientCertificateNode();
        node.setValue(new Variant((Object)clientCertificate));
    }

    @Override
    public ByteString readClientCertificate() throws UaException {
        try {
            return this.readClientCertificateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClientCertificate(ByteString clientCertificate) throws UaException {
        try {
            this.writeClientCertificateAsync(clientCertificate).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ByteString> readClientCertificateAsync() {
        return ((CompletableFuture)this.getClientCertificateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (ByteString)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeClientCertificateAsync(ByteString clientCertificate) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)clientCertificate));
        return this.getClientCertificateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getClientCertificateNode() throws UaException {
        try {
            return this.getClientCertificateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getClientCertificateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ClientCertificate", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

