/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;

public class CreateTransitionCommand
extends CreationCommand {
    static final Point SELF_TRANS_OFFSET = new Point(10, 50);
    private ECState source;
    private ECState destination;
    private Point sourceLocation;
    private Point destLocation;
    private ECC parent;
    private ECTransition transition;
    private String conditionExpression;
    private Event conditionEvent;
    private EditPartViewer viewer;

    public CreateTransitionCommand() {
    }

    public CreateTransitionCommand(ECState source, ECState destination, Event conditionEvent) {
        this.source = source;
        this.sourceLocation = source.getPosition().toScreenPoint();
        this.destination = destination;
        if (destination.getPosition() != null) {
            this.destLocation = destination.getPosition().toScreenPoint();
        }
        this.conditionEvent = conditionEvent;
    }

    public String getConditionExpression() {
        return this.conditionExpression;
    }

    public void setConditionExpression(String condition) {
        this.conditionExpression = condition;
    }

    public void setConditionEvent(Event conditionEvent) {
        this.conditionEvent = conditionEvent;
    }

    public Event getConditionEvent() {
        return this.conditionEvent;
    }

    public ECState getSource() {
        return this.source;
    }

    public void setSource(ECState source) {
        this.source = source;
    }

    public ECState getDestination() {
        return this.destination;
    }

    public void setDestination(ECState destination) {
        this.destination = destination;
    }

    public boolean canExecute() {
        return this.source != null && this.destination != null && this.source.getECC() != null && this.destLocation != null;
    }

    public void execute() {
        EditPart ep;
        this.parent = this.source.getECC();
        this.transition = LibraryElementFactory.eINSTANCE.createECTransition();
        this.parent.getECTransition().add((Object)this.transition);
        this.transition.updatePositionFromScreenCoordinates(this.calcTransitionBendPoint());
        this.transition.setSource(this.source);
        this.transition.setDestination(this.destination);
        this.transition.setConditionEvent(this.conditionEvent);
        if (this.conditionExpression != null) {
            this.transition.setConditionExpression(this.conditionExpression);
        } else if (this.conditionEvent == null) {
            this.transition.setConditionExpression("1");
        }
        if (this.viewer != null && (ep = this.viewer.getEditPartForModel((Object)this.transition)) != null) {
            this.viewer.select(ep);
        }
    }

    private Point calcTransitionBendPoint() {
        Point bendPoint = this.sourceLocation.getCopy();
        bendPoint.translate(this.destLocation.getDifference(this.sourceLocation).scale(0.5));
        if (this.source.equals(this.destination)) {
            bendPoint.translate(SELF_TRANS_OFFSET);
        }
        return bendPoint;
    }

    public boolean canUndo() {
        return this.parent != null;
    }

    public void undo() {
        this.transition.setSource(null);
        this.transition.setDestination(null);
        this.parent.getECTransition().remove((Object)this.transition);
    }

    public void redo() {
        this.parent.getECTransition().add((Object)this.transition);
        this.transition.setSource(this.source);
        this.transition.setDestination(this.destination);
    }

    public void setSourceLocation(Point location) {
        this.sourceLocation = location;
    }

    public void setDestinationLocation(Point location) {
        this.destLocation = location;
    }

    public void setViewer(EditPartViewer viewer) {
        this.viewer = viewer;
    }

    public Object getCreatedElement() {
        return this.transition;
    }
}

