/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.comgeneration.implementation.mediagenerators;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.fordiac.ide.comgeneration.implementation.mediagenerators.MediaSpecificGenerator;

public class MediaSpecificGeneratorFactory {
    private final Map<String, MediaSpecificGenerator> generators = new HashMap<String, MediaSpecificGenerator>();

    public void addGenerator(MediaSpecificGenerator generator) {
        this.generators.put(generator.getProtocolId(), generator);
    }

    public void removeGenerator(MediaSpecificGenerator generator) {
        this.generators.remove(generator.getProtocolId());
    }

    public MediaSpecificGenerator getForProtocolId(String protocolId) {
        return this.generators.get(protocolId);
    }

    public Collection<MediaSpecificGenerator> getForMediaType(String mediaType) {
        HashSet<MediaSpecificGenerator> generatorsForMediaType = new HashSet<MediaSpecificGenerator>();
        for (MediaSpecificGenerator generator : this.generators.values()) {
            if (!generator.getMediaType().equals(mediaType)) continue;
            generatorsForMediaType.add(generator);
        }
        return generatorsForMediaType;
    }

    public void resetAllGenerators() {
        for (MediaSpecificGenerator generator : this.generators.values()) {
            generator.reset();
        }
    }
}

