/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.elk.handlers;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.elk.FordiacLayout;
import org.eclipse.fordiac.ide.elk.Messages;
import org.eclipse.fordiac.ide.gef.editparts.AbstractFBNetworkEditPart;
import org.eclipse.fordiac.ide.model.helpers.ModelHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.typelibrary.SystemEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.editors.AbstractBreadCrumbEditor;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;

public class SystemLayoutHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Set<IFile> files = SystemLayoutHandler.collectFiles(event);
        if (SystemLayoutHandler.confirmation(files)) {
            List<Object> elements = SystemLayoutHandler.collectElements(event);
            Job job = SystemLayoutHandler.createJob(elements);
            job.setUser(true);
            job.schedule();
        }
        return Status.OK_STATUS;
    }

    private static Set<IFile> collectFiles(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        assert (selection instanceof StructuredSelection);
        List selectionList = ((StructuredSelection)selection).toList();
        HashSet<IFile> files = new HashSet<IFile>();
        for (Object obj : selectionList) {
            if (obj instanceof Application) {
                Application app = (Application)obj;
                files.add(app.getAutomationSystem().getTypeEntry().getFile());
                continue;
            }
            if (obj instanceof SubApp) {
                SubApp subapp = (SubApp)obj;
                files.add(ModelHelper.getFileFromContextChecked((EObject)subapp));
                continue;
            }
            if (obj instanceof IFile) {
                IFile file = (IFile)obj;
                files.add(file);
                continue;
            }
            if (!(obj instanceof IProject)) continue;
            IProject project = (IProject)obj;
            TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibrary(project);
            Stream.of(typeLibrary.getSystems(), typeLibrary.getCompositeFBTypes(), typeLibrary.getSubAppTypes()).flatMap(s -> s).forEach(typeEntry -> {
                boolean bl = files.add(typeEntry.getFile());
            });
        }
        return files;
    }

    private static List<Object> collectElements(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        assert (selection instanceof StructuredSelection);
        List selectionList = ((StructuredSelection)selection).toList();
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Object obj : selectionList) {
            if (obj instanceof Application) {
                Application app = (Application)obj;
                SystemLayoutHandler.collectElements(elements, List.of(app));
                continue;
            }
            if (obj instanceof SubApp) {
                SubApp subapp = (SubApp)obj;
                SystemLayoutHandler.collectElements(elements, List.of(subapp));
                continue;
            }
            if (obj instanceof IFile) {
                IFile file = (IFile)obj;
                if (SystemManager.isSystemFile((Object)file)) {
                    TypeEntry typeEntry2 = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
                    if (!(typeEntry2 instanceof SystemEntry)) continue;
                    SystemEntry sysEntry = (SystemEntry)typeEntry2;
                    SystemLayoutHandler.collectElements(elements, sysEntry.getType().getApplication());
                    continue;
                }
                elements.add(file);
                continue;
            }
            if (!(obj instanceof IProject)) continue;
            IProject project = (IProject)obj;
            TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibrary(project);
            typeLibrary.getSystems().map(SystemEntry::getType).forEach(sys -> SystemLayoutHandler.collectElements(elements, sys.getApplication()));
            typeLibrary.getCompositeFBTypes().forEach(typeEntry -> {
                boolean bl = elements.add(typeEntry.getFile());
            });
            typeLibrary.getSubAppTypes().forEach(typeEntry -> {
                boolean bl = elements.add(typeEntry.getFile());
            });
        }
        return elements;
    }

    private static <T extends EObject> void collectElements(List<Object> saveList, List<T> elements) {
        for (EObject elem : elements) {
            FBNetwork network;
            block5: {
                EObject eObject;
                saveList.add(elem);
                Objects.requireNonNull(elem);
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SubApp.class, Application.class}, (Object)eObject, 0)) {
                    case 0: {
                        SubApp subapp = (SubApp)eObject;
                        network = subapp.getSubAppNetwork();
                        break block5;
                    }
                    case 1: {
                        Application app = (Application)eObject;
                        network = app.getFBNetwork();
                        break block5;
                    }
                }
                continue;
            }
            List<SubApp> subapps = network.getNetworkElements().stream().filter(UntypedSubApp.class::isInstance).map(SubApp.class::cast).toList();
            SystemLayoutHandler.collectElements(saveList, subapps);
        }
    }

    private static boolean confirmation(Set<IFile> files) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        String title = Messages.SystemLayout_ConfirmationTitle;
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.SystemLayout_ConfirmationMessage);
        sb.append(System.lineSeparator());
        sb.append(Messages.SystemLayout_ConfirmationFilesAffected);
        sb.append(System.lineSeparator());
        for (IFile file : files) {
            sb.append(file.getName()).append(System.lineSeparator());
        }
        return MessageDialog.openQuestion((Shell)shell, (String)title, (String)sb.toString());
    }

    private static Job createJob(final List<Object> elements) {
        return new Job(Messages.SystemLayout_ProgressTitle){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.SystemLayout_ProgressMessage, elements.size());
                HashSet visited = new HashSet();
                HashSet editors = new HashSet();
                for (Object elem : elements) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (elem instanceof EObject) {
                        EObject modelElement = (EObject)elem;
                        Display.getDefault().syncExec(() -> SystemLayoutHandler.layoutModel(modelElement, visited, editors));
                    } else if (elem instanceof IFile) {
                        IFile file = (IFile)elem;
                        Display.getDefault().syncExec(() -> SystemLayoutHandler.layoutType(file, editors));
                    }
                    monitor.worked(1);
                }
                Display.getDefault().syncExec(() -> {
                    for (IEditorPart editor : editors) {
                        editor.doSave(monitor);
                    }
                });
                monitor.done();
                return Status.OK_STATUS;
            }
        };
    }

    private static void layoutModel(EObject obj, Set<Object> visited, Set<IEditorPart> editors) {
        IFile file;
        EObject refElement = SystemLayoutHandler.getBreadCrumbRefElement(obj);
        if (visited.contains(refElement)) {
            return;
        }
        visited.add(refElement);
        EObject root = EcoreUtil.getRootContainer((EObject)obj);
        if (!(root instanceof LibraryElement)) {
            return;
        }
        if (root instanceof SubAppType) {
            SubAppType type = (SubAppType)root;
            if (obj instanceof SubApp) {
                SubApp subapp = (SubApp)obj;
                SystemLayoutHandler.layoutSubappInTypedSubapp(subapp, type, editors);
                return;
            }
        }
        if ((file = ((LibraryElement)root).getTypeEntry().getFile()) == null) {
            return;
        }
        AbstractBreadCrumbEditor editor = (AbstractBreadCrumbEditor)SystemLayoutHandler.openEditor(file);
        if (editor == null) {
            return;
        }
        SystemLayoutHandler.layoutBreadcrumbEditor(refElement, editor);
        editors.add((IEditorPart)editor);
    }

    private static void layoutSubappInTypedSubapp(SubApp subapp, SubAppType type, Set<IEditorPart> editors) {
        IEditorPart iEditorPart = SystemLayoutHandler.openEditor(type.getTypeEntry().getFile());
        if (iEditorPart instanceof FormEditor) {
            FormEditor multiPageEditor = (FormEditor)iEditorPart;
            AbstractBreadCrumbEditor breadcrumbEditor = (AbstractBreadCrumbEditor)multiPageEditor.getAdapter(AbstractBreadCrumbEditor.class);
            multiPageEditor.setActiveEditor((IEditorPart)breadcrumbEditor);
            SystemLayoutHandler.layoutBreadcrumbEditor(SystemLayoutHandler.getBreadCrumbRefElement((EObject)subapp), breadcrumbEditor);
            ArrayList<EObject> elements = new ArrayList<EObject>();
            SystemLayoutHandler.collectSubapps(elements, subapp.getSubAppNetwork());
            for (EObject elem : elements) {
                SystemLayoutHandler.layoutBreadcrumbEditor(SystemLayoutHandler.getBreadCrumbRefElement(elem), breadcrumbEditor);
            }
            editors.add((IEditorPart)multiPageEditor);
        }
    }

    private static void layoutType(IFile file, Set<IEditorPart> editors) {
        IEditorPart iEditorPart = SystemLayoutHandler.openEditor(file);
        if (iEditorPart instanceof FormEditor) {
            FormEditor multiPageEditor = (FormEditor)iEditorPart;
            LibraryElement libraryElement = (LibraryElement)multiPageEditor.getAdapter(LibraryElement.class);
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SubAppType.class, CompositeFBType.class}, (Object)libraryElement, 0)) {
                case 0: {
                    SubAppType subappType = (SubAppType)libraryElement;
                    SystemLayoutHandler.handleSubappType(multiPageEditor, subappType);
                    editors.add((IEditorPart)multiPageEditor);
                    break;
                }
                case 1: {
                    CompositeFBType cFBType = (CompositeFBType)libraryElement;
                    SystemLayoutHandler.handleCompositeType(multiPageEditor);
                    editors.add((IEditorPart)multiPageEditor);
                    break;
                }
            }
        }
    }

    private static void handleSubappType(FormEditor multiPageEditor, SubAppType subappType) {
        AbstractBreadCrumbEditor breadcrumbEditor = (AbstractBreadCrumbEditor)multiPageEditor.getAdapter(AbstractBreadCrumbEditor.class);
        multiPageEditor.setActiveEditor((IEditorPart)breadcrumbEditor);
        GraphicalViewer viewer = (GraphicalViewer)multiPageEditor.getAdapter(GraphicalViewer.class);
        viewer.flush();
        FordiacLayout.blockLayout((IEditorPart)multiPageEditor, (AbstractFBNetworkEditPart)viewer.getRootEditPart().getContents());
        ArrayList<EObject> elements = new ArrayList<EObject>();
        SystemLayoutHandler.collectSubapps(elements, subappType.getFBNetwork());
        for (EObject elem : elements) {
            SystemLayoutHandler.layoutBreadcrumbEditor(SystemLayoutHandler.getBreadCrumbRefElement(elem), breadcrumbEditor);
        }
    }

    private static void handleCompositeType(FormEditor multiPageEditor) {
        FBNetworkEditor networkEditor = (FBNetworkEditor)multiPageEditor.getAdapter(FBNetworkEditor.class);
        multiPageEditor.setActiveEditor((IEditorPart)networkEditor);
        GraphicalViewer viewer = (GraphicalViewer)multiPageEditor.getAdapter(GraphicalViewer.class);
        viewer.flush();
        FordiacLayout.blockLayout((IEditorPart)multiPageEditor, (AbstractFBNetworkEditPart)viewer.getRootEditPart().getContents());
    }

    private static IEditorPart openEditor(IFile file) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            return IDE.openEditor((IWorkbenchPage)page, (IFile)file);
        }
        catch (PartInitException e) {
            FordiacLogHelper.logError((String)"System Explorer Layout: failed to open editor", (Throwable)e);
            return null;
        }
    }

    private static void collectSubapps(List<EObject> saveList, FBNetwork network) {
        List<SubApp> subapps = network.getNetworkElements().stream().filter(UntypedSubApp.class::isInstance).map(SubApp.class::cast).toList();
        saveList.addAll(subapps);
        subapps.forEach(sub -> SystemLayoutHandler.collectSubapps(saveList, sub.getSubAppNetwork()));
    }

    private static void layoutBreadcrumbEditor(EObject refElement, AbstractBreadCrumbEditor editor) {
        editor.getBreadcrumb().setInput((Object)refElement);
        GraphicalViewer viewer = (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
        viewer.flush();
        FordiacLayout.blockLayout((IEditorPart)editor, (AbstractFBNetworkEditPart)viewer.getRootEditPart().getContents());
    }

    private static EObject getBreadCrumbRefElement(EObject sel) {
        SubApp subApp;
        FBNetworkElement fbnEl;
        EObject refElement = sel;
        if (sel instanceof FBNetworkElement && (fbnEl = (FBNetworkElement)sel).getTypeEntry() != null || sel instanceof Group) {
            refElement = sel.eContainer().eContainer();
        }
        while (refElement instanceof SubApp && (subApp = (SubApp)refElement).isUnfolded()) {
            refElement = refElement.eContainer().eContainer();
        }
        return refElement;
    }
}

