/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.navigator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementProvider;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementStateListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class LibraryElementContentProvider
extends AdapterFactoryContentProvider {
    private final List<Notifier> targets = new ArrayList<Notifier>();
    private final Adapter typeEntryAdapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            Object object = notification.getNotifier();
            if (object instanceof TypeEntry) {
                TypeEntry entry = (TypeEntry)object;
                if ("TYPE_ENTRY_TYPE_FEATURE".equals(notification.getFeature())) {
                    LibraryElementContentProvider.super.notifyChanged((Notification)new ViewerNotification(notification, (Object)entry.getFile()));
                }
            }
        }
    };
    private final LibraryElementStateListener elementStateListener = new LibraryElementStateListener(){

        public void elementConnected(IEditorInput input) {
            this.fireElementChanged(input);
        }

        public void elementDisconnected(IEditorInput input) {
            this.fireElementChanged(input);
        }

        public void elementContentReplaced(IEditorInput input) {
            this.fireElementChanged(input);
        }

        private void fireElementChanged(IEditorInput input) {
            if (input instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)input;
                LibraryElementContentProvider.super.notifyChanged((Notification)new ViewerNotification((Notification)new NotificationImpl(1, (Object)fileEditorInput.getFile(), (Object)fileEditorInput.getFile()), (Object)fileEditorInput.getFile()));
            }
        }
    };

    public LibraryElementContentProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
        LibraryElementProvider.INSTANCE.addLibraryElementStateListener(this.elementStateListener);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            TypeEntry entry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
            if (entry == null) {
                return new Object[0];
            }
            this.hookToTypeEntry(entry);
            LibraryElement libraryElement = LibraryElementContentProvider.getLibraryElement(file, entry);
            if (libraryElement == null) {
                return new Object[0];
            }
            return super.getChildren((Object)libraryElement);
        }
        return super.getChildren(parentElement);
    }

    protected static LibraryElement getLibraryElement(IFile file, TypeEntry entry) {
        LibraryElement libraryElement = LibraryElementProvider.INSTANCE.getLibraryElement((IEditorInput)new FileEditorInput(file));
        if (libraryElement != null) {
            return libraryElement;
        }
        return entry.getType();
    }

    public Object getParent(Object object) {
        Object parent = super.getParent(object);
        if (parent instanceof LibraryElement) {
            LibraryElement libElement = (LibraryElement)parent;
            return libElement.getTypeEntry().getFile();
        }
        return parent;
    }

    protected void hookToTypeEntry(TypeEntry entry) {
        if (!entry.eAdapters().contains((Object)this.typeEntryAdapter)) {
            entry.eAdapters().add((Object)this.typeEntryAdapter);
            this.targets.add((Notifier)entry);
        }
    }

    public void dispose() {
        LibraryElementProvider.INSTANCE.addLibraryElementStateListener(this.elementStateListener);
        this.targets.forEach(entry -> {
            boolean bl = entry.eAdapters().remove((Object)this.typeEntryAdapter);
        });
        this.targets.clear();
        super.dispose();
    }

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object instanceof LibraryElement) {
            LibraryElement libElement = (LibraryElement)object;
            super.notifyChanged((Notification)new ViewerNotification(notification, (Object)libElement.getTypeEntry().getFile()));
        } else {
            super.notifyChanged(notification);
        }
    }
}

