/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.navigator;

import java.util.Arrays;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class LibraryElementLabelProvider
extends AdapterFactoryLabelProvider {
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    protected Image getDecoratedImage(IResource element, ImageDescriptor imageDescriptor) {
        if (imageDescriptor != null) {
            return (Image)this.resourceManager.get((DeviceResourceDescriptor)LibraryElementLabelProvider.decorateImage(element, imageDescriptor));
        }
        return null;
    }

    private static ImageDescriptor decorateImage(IResource element, ImageDescriptor imageDescriptor) {
        if (!element.exists()) {
            return imageDescriptor;
        }
        ImageDescriptor overlay = LibraryElementLabelProvider.getErrorOverlay(element);
        if (overlay != null) {
            return new DecorationOverlayIcon(imageDescriptor, overlay, 2);
        }
        return imageDescriptor;
    }

    private static ImageDescriptor getErrorOverlay(IResource element) {
        ImageDescriptor overlay = null;
        try {
            IMarker[] problems = element.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            if (problems.length > 0) {
                int problemSeverity = Arrays.stream(problems).mapToInt(p -> p.getAttribute("severity", -1)).max().orElse(-1);
                switch (problemSeverity) {
                    case 2: {
                        overlay = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_ERROR");
                        break;
                    }
                    case 1: {
                        overlay = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_WARNING");
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
        return overlay;
    }

    public LibraryElementLabelProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }
}

