/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring;

import java.util.EnumSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ConfigurableModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.IFordiacPreviewChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ReconnectPinByName;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ReconnectPinModelEdit
extends ConfigurableModelEdit<BlockFBNetworkElement> {
    private final String newName;
    private final String oldName;

    public ReconnectPinModelEdit(URI elementURI, Class<BlockFBNetworkElement> elementClass, String newName, String oldName) {
        super("Handle connection of : " + oldName, elementURI, elementClass);
        this.newName = newName;
        this.oldName = oldName;
    }

    @Override
    protected Command createCommand(BlockFBNetworkElement element) {
        return new ReconnectPinByName(this.oldName, this.newName, element, this.getState());
    }

    @Override
    public EnumSet<IFordiacPreviewChange.ChangeState> getAllowedChoices() {
        return EnumSet.of(IFordiacPreviewChange.ChangeState.RECONNECT, IFordiacPreviewChange.ChangeState.DELETE);
    }

    @Override
    public EnumSet<IFordiacPreviewChange.ChangeState> getDefaultSelection() {
        return EnumSet.of(IFordiacPreviewChange.ChangeState.RECONNECT);
    }

    @Override
    public void initializeValidationData(BlockFBNetworkElement element, IProgressMonitor pm) {
    }

    @Override
    public RefactoringStatus isValid(BlockFBNetworkElement element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }
}

