/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.connection.commands;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.fordiac.ide.model.commands.create.CreateInterfaceElementCommand;
import org.eclipse.fordiac.ide.model.commands.create.WithCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteInterfaceCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterfaceFBType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class ReplaceVarsWithStructCommand
extends Command {
    private final Collection<String> vars;
    private final DataType struct;
    private final String name;
    private final InterfaceList interfacelist;
    private final boolean isInput;
    private final int position;
    List<String> withs;
    CreateInterfaceElementCommand createStruct;
    private CompoundCommand editFBsCommand;
    private CompoundCommand createWithsCommand;

    public ReplaceVarsWithStructCommand(Collection<String> vars, DataType struct, String name, InterfaceList interfacelist, boolean isInput, int position) {
        this.vars = Objects.requireNonNull(vars);
        this.struct = Objects.requireNonNull(struct);
        this.name = Objects.requireNonNull(name);
        this.interfacelist = Objects.requireNonNull(interfacelist);
        this.isInput = isInput;
        this.position = position;
    }

    public boolean canExecute() {
        return !(this.interfacelist.eContainer() instanceof ServiceInterfaceFBType);
    }

    public void execute() {
        this.editFBsCommand = new CompoundCommand();
        this.createWithsCommand = new CompoundCommand();
        this.withs = (this.isInput ? this.interfacelist.getInputVars() : this.interfacelist.getOutputVars()).stream().filter(vardec -> this.vars.contains(vardec.getName())).map(VarDeclaration::getWiths).flatMap(Collection::stream).map(with -> ((Event)with.eContainer()).getName()).distinct().toList();
        this.vars.forEach(varName -> this.editFBsCommand.add((Command)(this.isInput ? new DeleteInterfaceCommand(this.interfacelist.getInput(List.of(varName))) : new DeleteInterfaceCommand(this.interfacelist.getOutput(List.of(varName))))));
        this.createStruct = new CreateInterfaceElementCommand(this.struct, this.name, this.interfacelist, this.isInput, this.position);
        this.editFBsCommand.add((Command)this.createStruct);
        this.editFBsCommand.execute();
        this.withs.forEach(width -> this.createWithsCommand.add((Command)new WithCreateCommand(this.interfacelist.getEvent(width), (VarDeclaration)this.createStruct.getCreatedElement())));
        this.createWithsCommand.execute();
    }

    public boolean canUndo() {
        return this.editFBsCommand.canUndo() && this.createWithsCommand.canUndo();
    }

    public void undo() {
        this.createWithsCommand.undo();
        this.editFBsCommand.undo();
    }

    public boolean canRedo() {
        return this.editFBsCommand.canRedo() && this.createWithsCommand.canRedo();
    }

    public void redo() {
        this.editFBsCommand.redo();
        this.createWithsCommand.redo();
    }
}

