/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.copy;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class CopyTypeChange
extends Change {
    private final URI destination;
    private String newPackageName;

    protected CopyTypeChange(URI destination) {
        this.destination = destination;
    }

    public void initializeValidationData(IProgressMonitor pm) {
        this.newPackageName = PackageNameHelper.getPackageNameFromURI((URI)this.destination);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public String getName() {
        return MessageFormat.format(Messages.MoveTypeToPackage_RenamePackageTo, this.newPackageName);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        Optional<Resource> resource = CopyTypeChange.getResource(this.destination);
        if (resource.isEmpty()) {
            throw new CoreException(Status.error((String)MessageFormat.format(Messages.CopyTypeChange_CannotLoadResource, this.destination)));
        }
        Optional<LibraryElement> optElement = CopyTypeChange.getLibraryElement(resource.get());
        if (optElement.isEmpty()) {
            return null;
        }
        LibraryElement element = optElement.get();
        String typeName = TypeEntry.getTypeNameFromFileName((String)this.destination.lastSegment());
        if (!element.getName().equals(typeName)) {
            element.setName(typeName);
        }
        PackageNameHelper.setPackageName((LibraryElement)element, (String)this.newPackageName);
        try {
            resource.get().save(Map.of());
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)MessageFormat.format(Messages.CopyTypeChange_CannotSaveResource, this.destination), (Throwable)e));
        }
        return null;
    }

    public Resource getModifiedElement() {
        return CopyTypeChange.getResource(this.destination).orElse(null);
    }

    public Object[] getAffectedObjects() {
        Resource res = this.getModifiedElement();
        if (res != null) {
            return new Object[]{res};
        }
        return super.getAffectedObjects();
    }

    private static Optional<Resource> getResource(URI uri) {
        if (!uri.isPlatformResource()) {
            return Optional.empty();
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(uri, true);
        if (resource == null || !resource.getErrors().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(resource);
    }

    private static Optional<LibraryElement> getLibraryElement(Resource resource) {
        return resource.getContents().stream().filter(LibraryElement.class::isInstance).map(LibraryElement.class::cast).findFirst();
    }
}

