/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.rename;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.search.types.BlockTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.search.types.DataTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ModelEditChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.RefactoringUtil;
import org.eclipse.fordiac.ide.typemanagement.refactoring.UpdateFBInstanceModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.UpdateTypeEntryChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.move.MoveTypeModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.move.UpdateTypeEntryFileChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.rename.RenameUpdateFBTypeInterfaceModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.rename.RenameUpdateStructDataTypeMemberVariableModelEdit;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class RenameTypeRefactoringParticipant
extends RenameParticipant {
    private IResource resource;
    private String newName;

    protected boolean initialize(Object element) {
        if (element instanceof IResource) {
            IResource res;
            this.resource = res = (IResource)element;
            this.newName = this.getArguments().getNewName();
            return RefactoringUtil.containsTypeEntryFile(this.resource);
        }
        return false;
    }

    public String getName() {
        return Messages.RenameType_Name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("Checking preconditions...", 1);
            this.checkFileEnding(status);
            this.checkFileExists(status);
        }
        finally {
            monitor.done();
        }
        return status;
    }

    protected void checkFileEnding(RefactoringStatus result) {
        if (this.resource.getFileExtension() != null && !this.newName.endsWith(this.resource.getFileExtension())) {
            result.addFatalError("The file-ending is different to the old one!");
        }
    }

    protected void checkFileExists(RefactoringStatus result) {
        if (this.resource.getParent().findMember(this.newName) != null) {
            result.addFatalError("File already exists!");
        }
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!(this.resource instanceof IFolder)) {
            return null;
        }
        ArrayList modelEdits = new ArrayList();
        ArrayList<CompositeChange> changes = new ArrayList<CompositeChange>();
        this.processTypeFiles(this.resource, this.resource.getFullPath(), (typeEntry, path) -> {
            IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            String newPackageName = PackageNameHelper.getPackageNameFromFile((IFile)newFile);
            modelEdits.add(new MoveTypeModelEdit(newPackageName, MessageFormat.format(Messages.MoveTypeToPackage_RenamePackageTo, newPackageName), typeEntry.getURI()));
            changes.add((CompositeChange)new UpdateTypeEntryFileChange(typeEntry.getFile(), (TypeEntry)typeEntry, newFile));
        });
        changes.addFirst(ModelEditChange.fromModelEdits(Messages.CopyTypeChange_RenamePackage, modelEdits));
        return new CompositeChange(Messages.CopyTypeChange_RenamePackage, (Change[])changes.toArray(Change[]::new));
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("Creating change...", 1);
            CompositeChange change = new CompositeChange(Messages.Refactoring_RenameChangeName);
            IResource iResource = this.resource;
            if (iResource instanceof IFile) {
                IFile file = (IFile)iResource;
                TypeEntry entry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
                String newTypeName = TypeEntry.getTypeNameFromFileName((String)this.newName);
                change.add((Change)new UpdateTypeEntryChange(entry.getFile(), entry, newTypeName, entry.getTypeName()));
            }
            ArrayList modelEdits = new ArrayList();
            this.processTypeFiles(this.resource, this.resource.getFullPath(), (typeEntry, path) -> this.addModelEditsForType(modelEdits, (TypeEntry)typeEntry, (IPath)path));
            change.add((Change)ModelEditChange.fromModelEdits(Messages.Refactoring_StructUsers, modelEdits));
            CompositeChange compositeChange = change;
            return compositeChange;
        }
        finally {
            monitor.done();
        }
    }

    private void processTypeFiles(IResource resource, IPath newPath, BiConsumer<TypeEntry, IPath> processor) throws CoreException {
        newPath = resource == this.resource ? newPath.removeLastSegments(1).append(this.newName) : newPath.append(resource.getName());
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            TypeEntry entry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
            if (entry != null) {
                processor.accept(entry, newPath);
            }
        } else if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                this.processTypeFiles(member, newPath, processor);
                ++n2;
            }
        }
    }

    private void addModelEditsForType(List<ModelEdit<?>> modelEdits, TypeEntry typeEntry, IPath newPath) {
        LibraryElement type = typeEntry.getType();
        if (type instanceof StructuredType) {
            this.createStructChanges((DataTypeEntry)typeEntry, modelEdits, newPath);
        } else if (type instanceof FBType) {
            RenameTypeRefactoringParticipant.createFBDataChange(typeEntry, modelEdits);
        }
    }

    private void createStructChanges(DataTypeEntry dataTypeEntry, List<ModelEdit<?>> modelEdits, IPath newPath) {
        DataTypeInstanceSearch dataTypeInstanceSearch = new DataTypeInstanceSearch(dataTypeEntry);
        HashSet rootElements = new HashSet();
        dataTypeInstanceSearch.performSearch().forEach(obj -> {
            if (obj instanceof VarDeclaration) {
                VarDeclaration varDecl = (VarDeclaration)obj;
                this.createSubChange(varDecl, dataTypeEntry, rootElements, modelEdits, newPath);
            } else if (obj instanceof StructManipulator) {
                StructManipulator structMan = (StructManipulator)obj;
                modelEdits.add(new UpdateFBInstanceModelEdit((BlockFBNetworkElement)structMan, (TypeEntry)dataTypeEntry));
            }
        });
    }

    private void createSubChange(VarDeclaration varDecl, DataTypeEntry dataTypeEntry, Set<EObject> rootElements, List<ModelEdit<?>> modelEdits, IPath newPath) {
        if (varDecl.getBlockFBNetworkElement() != null) {
            if (varDecl.getBlockFBNetworkElement() instanceof StructManipulator) {
                return;
            }
            if (rootElements.add((EObject)varDecl.getBlockFBNetworkElement())) {
                modelEdits.add(new UpdateFBInstanceModelEdit(varDecl.getBlockFBNetworkElement(), (TypeEntry)dataTypeEntry));
            }
        } else {
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)varDecl);
            if (!rootElements.add(rootContainer)) {
                return;
            }
            if (rootContainer instanceof StructuredType) {
                StructuredType stElement = (StructuredType)rootContainer;
                modelEdits.add(new RenameUpdateStructDataTypeMemberVariableModelEdit(varDecl, dataTypeEntry));
                this.createStructChanges((DataTypeEntry)stElement.getTypeEntry(), modelEdits, newPath);
            }
            if (rootContainer instanceof AttributeDeclaration) {
                modelEdits.add(new RenameUpdateStructDataTypeMemberVariableModelEdit(varDecl, dataTypeEntry));
            }
            if (rootContainer instanceof FBType) {
                FBType fbType = (FBType)rootContainer;
                if (dataTypeEntry.getType() instanceof StructuredType) {
                    IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(newPath);
                    modelEdits.add(new RenameUpdateFBTypeInterfaceModelEdit(fbType, dataTypeEntry.getTypeName(), PackageNameHelper.getFullTypeNameFromFile((IFile)newFile), PackageNameHelper.getPackageNameFromFile((IFile)dataTypeEntry.getFile())));
                }
            }
        }
    }

    private static void createFBDataChange(TypeEntry typeEntry, List<ModelEdit<?>> modelEdits) {
        new BlockTypeInstanceSearch(typeEntry).performSearch().stream().filter(BlockFBNetworkElement.class::isInstance).map(BlockFBNetworkElement.class::cast).map(fbn -> new UpdateFBInstanceModelEdit((BlockFBNetworkElement)fbn, typeEntry)).forEach(modelEdits::add);
    }
}

