/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui.annotation;

import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugElement;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugStackFrame;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugTarget;
import org.eclipse.fordiac.ide.deployment.debug.ui.annotation.WatchValueAnnotation;
import org.eclipse.fordiac.ide.deployment.debug.watch.IContainerWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.IInterfaceElementWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.IWatch;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.ui.annotation.FordiacMarkerGraphicalAnnotationModel;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotation;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotationProvider;

public class WatchValueAnnotationProvider
implements GraphicalAnnotationProvider,
IDebugEventSetListener {
    private FordiacMarkerGraphicalAnnotationModel model;

    public boolean initialize(GraphicalAnnotationModel model, Object context) {
        if (model instanceof FordiacMarkerGraphicalAnnotationModel) {
            IFile file;
            FordiacMarkerGraphicalAnnotationModel markerModel = (FordiacMarkerGraphicalAnnotationModel)model;
            if (context instanceof IFile && "SYS".equalsIgnoreCase((file = (IFile)context).getFileExtension())) {
                this.model = markerModel;
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
                return true;
            }
        }
        return false;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        HashSet<GraphicalAnnotation> add = new HashSet<GraphicalAnnotation>();
        HashSet<GraphicalAnnotation> remove = new HashSet<GraphicalAnnotation>();
        HashSet<GraphicalAnnotation> changed = new HashSet<GraphicalAnnotation>();
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (this.isRelevant(event)) {
                Object object;
                Objects.requireNonNull(event.getSource());
                Object object2 = object;
                int n3 = 0;
                block6: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IWatch.class, DeploymentDebugStackFrame.class, DeploymentDebugTarget.class}, (Object)object2, n3)) {
                        case 0: {
                            IWatch watch = (IWatch)object;
                            if (event.getKind() != 16) {
                                object2 = object;
                                n3 = 1;
                                continue block6;
                            }
                            this.handleWatchChanged(watch, add, changed);
                            break block6;
                        }
                        case 1: {
                            DeploymentDebugStackFrame stackFrame = (DeploymentDebugStackFrame)object;
                            if (event.getKind() != 16) {
                                object2 = object;
                                n3 = 2;
                                continue block6;
                            }
                            this.handleWatchesChanged(stackFrame, add, remove, changed);
                            break block6;
                        }
                        case 2: {
                            DeploymentDebugTarget debugTarget = (DeploymentDebugTarget)object;
                            if (event.getKind() != 8) {
                                object2 = object;
                                n3 = 3;
                                continue block6;
                            }
                            this.handleTerminated();
                            break block6;
                        }
                        default: {
                            return;
                        }
                    }
                    break;
                }
            }
            ++n2;
        }
        this.model.updateAnnotations(add, remove, changed);
    }

    private void handleWatchesChanged(DeploymentDebugStackFrame stackFrame, Set<GraphicalAnnotation> add, Set<GraphicalAnnotation> remove, Set<GraphicalAnnotation> changed) {
        stackFrame.getDebugTarget().getWatches().values().forEach(watch -> this.handleWatchChanged((IWatch)watch, add, changed));
        this.model.forEach(annotation -> {
            if (annotation instanceof WatchValueAnnotation) {
                WatchValueAnnotation watchValueAnnotation = (WatchValueAnnotation)((Object)annotation);
                if (!add.contains(annotation) && !changed.contains(annotation)) {
                    remove.add(watchValueAnnotation);
                }
            }
        });
    }

    protected void handleWatchChanged(IWatch watch, Set<GraphicalAnnotation> add, Set<GraphicalAnnotation> changed) {
        if (watch instanceof IInterfaceElementWatch) {
            IInterfaceElementWatch interfaceElementWatch = (IInterfaceElementWatch)watch;
            this.handleInterfaceElementWatchChanged(interfaceElementWatch, add, changed);
        }
        if (watch instanceof IContainerWatch) {
            IContainerWatch containerWatch = (IContainerWatch)watch;
            containerWatch.getSubWatches().forEach(subWatch -> this.handleWatchChanged((IWatch)subWatch, add, changed));
        }
    }

    private void handleInterfaceElementWatchChanged(IInterfaceElementWatch watch, Set<GraphicalAnnotation> add, Set<GraphicalAnnotation> changed) {
        Optional<IInterfaceElement> target = this.findTarget((IWatch)watch, IInterfaceElement.class);
        if (target.isPresent()) {
            WatchValueAnnotationProvider.getTargetFBNetworks(target.get()).forEachOrdered(network -> this.handleInterfaceElementWatchChanged(watch, (IInterfaceElement)target.get(), (FBNetwork)network, add, changed));
        }
    }

    private void handleInterfaceElementWatchChanged(IInterfaceElementWatch watch, IInterfaceElement target, FBNetwork network, Set<GraphicalAnnotation> add, Set<GraphicalAnnotation> changed) {
        Optional<WatchValueAnnotation> annotation = this.findAnnotation(network, target);
        if (annotation.isEmpty()) {
            add.add(new WatchValueAnnotation(network, target, watch));
        } else {
            changed.add(annotation.get());
        }
    }

    private <T extends INamedElement> Optional<T> findTarget(IWatch watch, Class<T> targetClass) {
        return this.model.getLibraryElement().findByQualifiedName(watch.getQualifiedName()).filter(targetClass::isInstance).map(targetClass::cast).findFirst();
    }

    private Optional<WatchValueAnnotation> findAnnotation(FBNetwork network, IInterfaceElement element) {
        return this.model.getAnnotations((Object)network).stream().filter(WatchValueAnnotation.class::isInstance).map(WatchValueAnnotation.class::cast).filter(annotation -> annotation.getElement() == element).findAny();
    }

    private static Stream<FBNetwork> getTargetFBNetworks(IInterfaceElement target) {
        BlockFBNetworkElement networkElement;
        BlockFBNetworkElement blockFBNetworkElement = networkElement = target.getBlockFBNetworkElement();
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AdapterFB.class}, (Object)blockFBNetworkElement, 0)) {
            case -1 -> Stream.empty();
            case 0 -> {
                AdapterFB adapterFB = (AdapterFB)blockFBNetworkElement;
                yield Stream.concat(Stream.ofNullable(networkElement.getFbNetwork()), WatchValueAnnotationProvider.getTargetFBNetworks((IInterfaceElement)adapterFB.getAdapterDecl()));
            }
            default -> Stream.ofNullable(networkElement.getFbNetwork());
        };
    }

    protected boolean isRelevant(DebugEvent event) {
        DeploymentDebugElement element;
        Object object = event.getSource();
        return object instanceof DeploymentDebugElement && (element = (DeploymentDebugElement)object).getDebugTarget().getSystem().getTypeEntry().getFile().equals((Object)this.model.getResource());
    }

    private void handleTerminated() {
        this.model.removeAnnotationIf(WatchValueAnnotation.class::isInstance);
    }

    public void refresh() {
    }

    public void reload() {
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }
}

