/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.eval;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.eclipse.fordiac.ide.deployment.data.ConnectionDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.ResourceDeploymentData;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.fordiac.ide.deployment.eval.DeploymentEvaluatorConfigurationBuilder;
import org.eclipse.fordiac.ide.deployment.eval.DeploymentEvaluatorTraceProxy;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.DeviceManagementInteractorFactory;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.util.IDeploymentListener;
import org.eclipse.fordiac.ide.model.eval.AbstractEvaluator;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public class DeploymentEvaluatorSharedState
implements Closeable {
    public static final String SHARED_STATE_NAME = DeploymentEvaluatorSharedState.class.getName();
    private final Resource resource;
    private final IDeviceManagementInteractor deviceManagementInteractor;

    protected DeploymentEvaluatorSharedState(DeploymentEvaluatorConfigurationBuilder builder) {
        this.resource = builder.createResource();
        this.deviceManagementInteractor = Objects.requireNonNull(DeviceManagementInteractorFactory.INSTANCE.getDeviceManagementInteractor(Objects.requireNonNull(this.resource.getDevice(), "Resource not in device")), "No valid device management interactor for profile " + this.resource.getDevice().getProfile());
        if (builder.isTrace()) {
            this.deviceManagementInteractor.addDeploymentListener((IDeploymentListener)new DeploymentEvaluatorTraceProxy());
        }
    }

    public static DeploymentEvaluatorSharedState fromContext(TypeLibrary typeLibrary) {
        return (DeploymentEvaluatorSharedState)AbstractEvaluator.getSharedResources().computeIfAbsent(SHARED_STATE_NAME, unused -> new DeploymentEvaluatorSharedState(DeploymentEvaluatorConfigurationBuilder.fromContext(AbstractEvaluator.currentContext(), typeLibrary)));
    }

    public void prepare() throws DeploymentException {
        if (!this.deviceManagementInteractor.isConnected()) {
            this.deviceManagementInteractor.connect();
            this.deviceManagementInteractor.createResource(this.resource);
            this.deviceManagementInteractor.startResource(this.resource);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.deviceManagementInteractor.isConnected()) {
                this.deviceManagementInteractor.deleteResource(this.resource.getName());
                this.deviceManagementInteractor.disconnect();
            }
        }
        catch (DeploymentException e) {
            throw new IOException(e);
        }
    }

    public void deploy(FBDeploymentData deploymentData) throws DeploymentException {
        this.deviceManagementInteractor.createFBInstance(deploymentData, this.resource);
        this.deviceManagementInteractor.startFB(this.resource, deploymentData);
    }

    public void deploy(ResourceDeploymentData deploymentData) throws DeploymentException {
        for (FBDeploymentData fBDeploymentData : deploymentData.getFbs()) {
            this.deviceManagementInteractor.createFBInstance(fBDeploymentData, deploymentData.getRes());
        }
        for (Map.Entry entry : deploymentData.getParams().entrySet()) {
            this.deviceManagementInteractor.writeFBParameter(deploymentData.getRes(), (String)entry.getKey(), (String)entry.getValue());
        }
        for (ConnectionDeploymentData connectionDeploymentData : deploymentData.getConnections()) {
            this.deviceManagementInteractor.createConnection(deploymentData.getRes(), connectionDeploymentData);
        }
        for (FBDeploymentData fBDeploymentData : deploymentData.getFbs()) {
            this.deviceManagementInteractor.startFB(deploymentData.getRes(), fBDeploymentData);
        }
    }

    public void delete(ResourceDeploymentData deploymentData) throws DeploymentException {
        for (ConnectionDeploymentData connection : deploymentData.getConnections()) {
            this.deviceManagementInteractor.deleteConnection(deploymentData.getRes(), connection);
        }
        for (FBDeploymentData fb : deploymentData.getFbs()) {
            this.deviceManagementInteractor.deleteFB(deploymentData.getRes(), fb);
        }
    }

    public void createFBInstance(FBDeploymentData deploymentData) throws DeploymentException {
        this.deviceManagementInteractor.createFBInstance(deploymentData, this.resource);
    }

    public void startFB(FBDeploymentData deploymentData) throws DeploymentException {
        this.deviceManagementInteractor.startFB(this.resource, deploymentData);
    }

    public void deleteFB(FBDeploymentData deploymentData) throws DeploymentException {
        this.deviceManagementInteractor.deleteFB(this.resource, deploymentData);
    }

    public void addWatch(String name) throws DeploymentException {
        this.deviceManagementInteractor.addWatch(this.resource, name);
    }

    public void removeWatch(String name) throws DeploymentException {
        this.deviceManagementInteractor.removeWatch(this.resource, name);
    }

    public Response readWatches() throws DeploymentException {
        return this.deviceManagementInteractor.readWatches();
    }

    public void triggerEvent(String name) throws DeploymentException {
        this.deviceManagementInteractor.triggerEvent(this.resource, name);
    }

    public void writeFBParameter(String value, FBDeploymentData deploymentData, VarDeclaration varDeclaration) throws DeploymentException {
        this.deviceManagementInteractor.writeFBParameter(this.resource, value, deploymentData, varDeclaration);
    }

    public void writeFBParameter(String name, String value) throws DeploymentException {
        this.deviceManagementInteractor.writeFBParameter(this.resource, name, value);
    }

    public void writeDeviceParameter(String name, String value) throws DeploymentException {
        this.deviceManagementInteractor.writeDeviceParameter(this.resource.getDevice(), name, value);
    }

    public void createConnection(ConnectionDeploymentData connection) throws DeploymentException {
        this.deviceManagementInteractor.createConnection(this.resource, connection);
    }

    public void deleteConnection(ConnectionDeploymentData connection) throws DeploymentException {
        this.deviceManagementInteractor.deleteConnection(this.resource, connection);
    }

    public Resource getResource() {
        return this.resource;
    }

    public IDeviceManagementInteractor getDeviceManagementInteractor() {
        return this.deviceManagementInteractor;
    }
}

