/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.fordiac.ide.ui.widget.nattable.AbstractColumnAccessor;
import org.eclipse.fordiac.ide.ui.widget.nattable.NatTableColumn;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;

public class SorterModel<T>
implements ISortModel {
    private List<T> sortingList;
    AbstractColumnAccessor<T, ? extends NatTableColumn> accessor;
    private final Map<Integer, SortDirectionEnum> sortDirections = new LinkedHashMap<Integer, SortDirectionEnum>();

    public SorterModel(AbstractColumnAccessor<T, ? extends NatTableColumn> columnaccessor) {
        this.sortingList = Collections.emptyList();
        this.accessor = columnaccessor;
    }

    public void setSortingList(List<T> list) {
        this.sortingList = list;
    }

    public List<Integer> getSortedColumnIndexes() {
        return new ArrayList<Integer>(this.sortDirections.keySet());
    }

    public boolean isColumnIndexSorted(int columnIndex) {
        return this.sortDirections.containsKey(columnIndex);
    }

    public SortDirectionEnum getSortDirection(int columnIndex) {
        return this.sortDirections.getOrDefault(columnIndex, SortDirectionEnum.NONE);
    }

    public int getSortOrder(int columnIndex) {
        return new ArrayList<Integer>(this.sortDirections.keySet()).indexOf(columnIndex);
    }

    public List<Comparator> getComparatorsForColumnIndex(int columnIndex) {
        Comparator<T> comp = this.getColumnComparator(columnIndex);
        return comp != null ? Collections.singletonList(comp) : Collections.emptyList();
    }

    public Comparator<T> getColumnComparator(int columnIndex) {
        return Comparator.comparing(att -> (String)this.accessor.getDataValue(att, columnIndex), String.CASE_INSENSITIVE_ORDER);
    }

    public void sort(int columnIndex, SortDirectionEnum sortDirection, boolean accumulate) {
        Comparator<T> comparator = this.getColumnComparator(columnIndex);
        if (comparator == null) {
            return;
        }
        if (sortDirection == SortDirectionEnum.DESC) {
            comparator = Collections.reverseOrder(comparator);
        }
        if (!accumulate) {
            this.sortDirections.clear();
        }
        Comparator<T> combined = null;
        for (int col : this.sortDirections.keySet()) {
            Comparator<T> colComp = this.getColumnComparator(columnIndex);
            if (this.sortDirections.get(col) == SortDirectionEnum.DESC) {
                colComp = Collections.reverseOrder(colComp);
            }
            Comparator<T> comparator2 = combined = combined == null ? colComp : combined.thenComparing(colComp);
        }
        this.sortDirections.put(columnIndex, sortDirection);
        this.sortingList.sort(comparator);
    }

    public void clear() {
        this.sortDirections.clear();
    }
}

