/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.resourceediting.editors;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementProvider;
import org.eclipse.fordiac.ide.resourceediting.editparts.ResourceDiagramEditPartFactory;
import org.eclipse.fordiac.ide.util.ColorManager;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorInput;

public class ResourceDiagramEditor
extends FBNetworkEditor {
    private final Adapter colorChangeListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == LibraryElementPackage.eINSTANCE.getColorizableElement_Color()) {
                ResourceDiagramEditor.this.updateGridColor();
            }
        }
    };

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == Resource.class) {
            return adapter.cast(this.getResource());
        }
        return (T)super.getAdapter(adapter);
    }

    private Resource getResource() {
        return this.getModel() != null ? (Resource)this.getModel().eContainer() : null;
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.updateGridColor();
    }

    protected EditPartFactory getEditPartFactory() {
        return new ResourceDiagramEditPartFactory((GraphicalEditor)this);
    }

    public void setInput(IEditorInput input) {
        Resource resource = (Resource)LibraryElementProvider.INSTANCE.getElement(input, Resource.class);
        if (resource == null) {
            throw new IllegalArgumentException("Resource editors only accept resources as valid inputs!");
        }
        this.removeColorChangeListener();
        this.setModel(resource.getFBNetwork());
        this.addColorChangeListener();
        super.setInput(input);
    }

    public void dispose() {
        this.removeColorChangeListener();
        super.dispose();
    }

    protected void addColorChangeListener() {
        if (this.getResource() != null) {
            this.getResource().getDevice().eAdapters().add((Object)this.colorChangeListener);
        }
    }

    protected void removeColorChangeListener() {
        if (this.getResource() != null) {
            this.getResource().getDevice().eAdapters().remove((Object)this.colorChangeListener);
        }
    }

    private void updateGridColor() {
        Color devColor;
        IFigure layer;
        if (this.getResource() != null && (layer = ((ZoomScalableFreeformRootEditPart)this.getViewer().getRootEditPart()).getLayer((Object)"Grid Layer")) != null && (devColor = this.getResource().getDevice().getColor()) != null) {
            org.eclipse.swt.graphics.Color newColor = ColorManager.getColor((RGB)new RGB(devColor.getRed(), devColor.getGreen(), devColor.getBlue()));
            layer.setForegroundColor(newColor);
        }
    }
}

