/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library.ui.wizards;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.library.LibraryManager;
import org.eclipse.fordiac.ide.library.LibraryRecord;
import org.eclipse.fordiac.ide.library.model.library.Required;
import org.eclipse.fordiac.ide.library.model.util.ManifestHelper;
import org.eclipse.fordiac.ide.library.ui.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class LibrarySelectionPage
extends WizardPage {
    private final List<LibraryRecord> libraries = new ArrayList<LibraryRecord>();
    private CheckboxTreeViewer treeViewer;
    private Button libraryNameSort;
    private final boolean showStandard;
    private final boolean showWorkspace;
    private VersionRange range;
    private SelectionAdapter listener;

    public LibrarySelectionPage(String pageName, boolean alwaysComplete, boolean showStandard, boolean showWorkspace) {
        super(pageName);
        this.setPageComplete(alwaysComplete);
        this.showStandard = showStandard;
        this.showWorkspace = showWorkspace;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTreeViewer(composite);
        Composite compositeConfiguring = new Composite(composite, 0);
        compositeConfiguring.setLayout((Layout)new GridLayout(2, true));
        compositeConfiguring.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTreeGroupConfiguring(compositeConfiguring);
        this.createColumnConfiguring(compositeConfiguring);
        this.findLibs();
        this.fillViewer(true);
        this.selectRange();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private void createColumnConfiguring(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.LibraryPage_Columns);
        group.setLayout((Layout)new RowLayout(256));
        Button showPath = new Button((Composite)group, 32);
        showPath.setText(Messages.LibraryPage_Path);
        showPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                TreeColumn[] columns = LibrarySelectionPage.this.treeViewer.getTree().getColumns();
                if (button.getSelection()) {
                    LibrarySelectionPage.this.createPathColumn();
                    LibrarySelectionPage.this.treeViewer.refresh();
                } else {
                    columns[3].dispose();
                }
            }
        });
    }

    private void createTreeViewer(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        tableComposite.setLayout((Layout)new GridLayout(1, true));
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer = new CheckboxTreeViewer(tableComposite, 2816);
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        tree.setHeaderVisible(true);
        tableComposite.layout();
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                if (LibrarySelectionPage.this.libraryNameSort.getSelection()) {
                    if (parentElement instanceof String) {
                        String name = (String)parentElement;
                        return LibrarySelectionPage.this.libraries.stream().filter(lib -> lib.name().equals(name)).sorted(Comparator.comparing(LibraryRecord::version).reversed()).toArray();
                    }
                } else if (parentElement instanceof String) {
                    String version = (String)parentElement;
                    return LibrarySelectionPage.this.libraries.stream().filter(lib -> lib.version().toString().equals(version)).sorted(Comparator.comparing(LibraryRecord::name)).toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof LibraryRecord) {
                    LibraryRecord lib = (LibraryRecord)element;
                    if (LibrarySelectionPage.this.libraryNameSort.getSelection()) {
                        return lib.name();
                    }
                    return lib.version().toString();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof String;
            }
        });
    }

    private void createTreeGroupConfiguring(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.LibraryPage_Sorting);
        group.setLayout((Layout)new RowLayout(256));
        this.libraryNameSort = new Button((Composite)group, 16);
        this.libraryNameSort.setText(Messages.LibraryPage_Name);
        this.libraryNameSort.setSelection(true);
        Button versionSort = new Button((Composite)group, 16);
        versionSort.setText(Messages.LibraryPage_Version);
        SelectionAdapter sortListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    LibrarySelectionPage.this.fillViewer(button == LibrarySelectionPage.this.libraryNameSort);
                }
            }
        };
        this.libraryNameSort.addSelectionListener((SelectionListener)sortListener);
        versionSort.addSelectionListener((SelectionListener)sortListener);
    }

    public boolean isPageComplete() {
        return super.isPageComplete() || this.treeViewer.getCheckedElements().length > 0;
    }

    private void findLibs() {
        this.libraries.clear();
        if (this.showStandard) {
            LibraryManager.INSTANCE.getStandardLibraries().forEach((symbolicName, reclist) -> reclist.forEach(this.libraries::add));
        }
        if (this.showWorkspace) {
            LibraryManager.INSTANCE.getExtractedLibraries().forEach((symbolicName, reclist) -> reclist.forEach(this.libraries::add));
        }
    }

    public Map<Required, URI> getChosenLibraries() {
        HashMap<Required, URI> libs = new HashMap<Required, URI>();
        Stream.of(this.treeViewer.getCheckedElements()).filter(LibraryRecord.class::isInstance).map(LibraryRecord.class::cast).forEach(lib -> {
            URI uRI = libs.put(ManifestHelper.createRequired((String)lib.symbolicName(), (String)lib.version().toString()), lib.uri());
        });
        return libs;
    }

    public void setStandardLibRange(VersionRange range) {
        this.range = range;
        this.selectRange();
    }

    private void selectRange() {
        if (this.range == null || this.treeViewer == null || this.libraries.isEmpty()) {
            return;
        }
        this.treeViewer.setCheckedElements((Object[])this.libraries.stream().filter(l -> this.range.includes(l.version())).toArray(LibraryRecord[]::new));
        this.treeViewer.refresh();
    }

    private void fillViewer(boolean isLibrary) {
        Object[] tempSelection = this.treeViewer.getCheckedElements();
        this.treeViewer.getTree().clearAll(true);
        String version = this.range != null ? this.range.getLeft().toString() : "";
        this.createColumns(isLibrary);
        if (this.listener != null) {
            this.treeViewer.getTree().removeSelectionListener((SelectionListener)this.listener);
        }
        if (isLibrary) {
            this.treeViewer.setInput(this.libraries.stream().map(LibraryRecord::name).distinct().sorted().toList());
            this.treeViewer.setCheckedElements(tempSelection);
            if (this.range != null && Collections.max(this.libraries, Comparator.comparing(LibraryRecord::version)).version().equals((Object)this.range.getLeft())) {
                Stream.of(this.treeViewer.getTree().getItems()).filter(r -> Stream.of(r.getItems()).anyMatch(d -> d.getText().equals(version))).forEach(r -> {
                    boolean bl = this.treeViewer.setChecked(r, true);
                });
            }
            this.treeViewer.getTree().addSelectionListener((SelectionListener)this.getLibraryNameListener());
        } else {
            this.treeViewer.setInput(this.libraries.stream().map(LibraryRecord::version).distinct().sorted(Comparator.reverseOrder()).map(Version::toString).toList());
            if (this.range != null) {
                Object[] children = ((ITreeContentProvider)this.treeViewer.getContentProvider()).getChildren((Object)version);
                this.treeViewer.setCheckedElements(tempSelection);
                if (Arrays.stream(children).allMatch(child -> this.treeViewer.getChecked(child))) {
                    this.treeViewer.setChecked((Object)version, true);
                }
            }
            this.treeViewer.getTree().addSelectionListener((SelectionListener)this.getVersionListener());
        }
        this.treeViewer.refresh();
    }

    private SelectionAdapter getLibraryNameListener() {
        this.listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 32 && event.item instanceof TreeItem) {
                    TreeItem item = (TreeItem)event.item;
                    LibrarySelectionPage.this.removeListener();
                    boolean checked = item.getChecked();
                    TreeItem treeItem = item.getParentItem();
                    if (treeItem instanceof TreeItem) {
                        TreeItem parent = treeItem;
                        if (checked) {
                            Stream.of(parent.getItems()).filter(i -> i != item).forEach(c -> c.setChecked(false));
                            Stream.of(parent.getItems()).max(Comparator.comparing(ti -> ((LibraryRecord)ti.getData()).version())).ifPresent(p -> parent.setChecked(p.equals(item)));
                        }
                    }
                    if (item.getItemCount() > 0) {
                        Stream.of(item.getItems()).forEach(ti -> ti.setChecked(false));
                        if (checked) {
                            Stream.of(item.getItems()).max(Comparator.comparing(ti -> ((LibraryRecord)ti.getData()).version())).ifPresent(r -> r.setChecked(true));
                        }
                    }
                    LibrarySelectionPage.this.addListener();
                }
            }
        };
        return this.listener;
    }

    private void addListener() {
        this.treeViewer.getTree().addSelectionListener((SelectionListener)this.listener);
        this.treeViewer.getTree().setRedraw(true);
    }

    private void removeListener() {
        this.treeViewer.getTree().removeSelectionListener((SelectionListener)this.listener);
        this.treeViewer.getTree().setRedraw(false);
    }

    private SelectionAdapter getVersionListener() {
        this.listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 32 && event.item instanceof TreeItem) {
                    TreeItem item = (TreeItem)event.item;
                    LibrarySelectionPage.this.removeListener();
                    boolean checked = item.getChecked();
                    TreeItem[] children = item.getItems();
                    if (children.length > 0) {
                        this.checkParentForVersionListener(item, checked, children);
                    } else {
                        this.checkChildForVersionListener(item);
                    }
                    LibrarySelectionPage.this.treeViewer.refresh();
                    LibrarySelectionPage.this.setPageComplete(LibrarySelectionPage.this.isPageComplete());
                    LibrarySelectionPage.this.addListener();
                }
            }

            private void checkChildForVersionListener(TreeItem item) {
                TreeItem parent = item.getParentItem();
                parent.setChecked(Stream.of(parent.getItems()).allMatch(TreeItem::getChecked));
                Stream.of(item.getParent().getItems()).filter(i -> i != parent).flatMap(e -> Arrays.stream(e.getItems())).filter(c -> c.getData() != null && ((LibraryRecord)c.getData()).name().equals(((LibraryRecord)item.getData()).name())).forEach(d -> d.setChecked(false));
            }

            private void checkParentForVersionListener(TreeItem item, boolean checked, TreeItem[] children) {
                Stream.of(children).forEach(c -> c.setChecked(checked));
                Set childrenNames = Stream.of(children).map(Widget::getData).map(LibraryRecord.class::cast).filter(Objects::nonNull).map(LibraryRecord::name).collect(Collectors.toSet());
                Stream.of(item.getParent().getItems()).filter(i -> i != item && i.getChecked()).forEach(p -> {
                    TreeItem[] treeItemArray = p.getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem child = treeItemArray[n2];
                        LibraryRecord childItem = (LibraryRecord)child.getData();
                        if (childrenNames.contains(childItem.name())) {
                            child.setChecked(false);
                        }
                        ++n2;
                    }
                    p.setChecked(false);
                });
            }
        };
        return this.listener;
    }

    private void createColumns(boolean isLibrary) {
        Stream.of(this.treeViewer.getTree().getColumns()).forEach(TreeColumn::dispose);
        TreeViewerColumn col1 = new TreeViewerColumn((TreeViewer)this.treeViewer, 0);
        TreeViewerColumn col2 = new TreeViewerColumn((TreeViewer)this.treeViewer, 0);
        TreeViewerColumn col3 = new TreeViewerColumn((TreeViewer)this.treeViewer, 0);
        if (isLibrary) {
            LibrarySelectionPage.createLibraryFirstColumn(col1, col2);
        } else {
            LibrarySelectionPage.createVersionFirstColumn(col1, col2);
        }
        col3.getColumn().setText(Messages.LibraryPage_Comment);
        col3.getColumn().setWidth(200);
        col3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LibraryRecord) {
                    LibraryRecord libdisplay = (LibraryRecord)element;
                    return libdisplay.comment();
                }
                return "";
            }
        });
    }

    private void createPathColumn() {
        TreeViewerColumn col4 = new TreeViewerColumn((TreeViewer)this.treeViewer, 0);
        col4.getColumn().setText(Messages.LibraryPage_Path);
        col4.getColumn().setWidth(200);
        col4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LibraryRecord) {
                    LibraryRecord libdisplay = (LibraryRecord)element;
                    return libdisplay.path().toString();
                }
                return "";
            }
        });
    }

    private static void createVersionFirstColumn(TreeViewerColumn col1, TreeViewerColumn col2) {
        col1.getColumn().setText(Messages.LibraryPage_Version);
        col1.getColumn().setWidth(100);
        col1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    String elem = (String)element;
                    return elem;
                }
                return "";
            }
        });
        col2.getColumn().setText(Messages.LibraryPage_Name);
        col2.getColumn().setWidth(150);
        col2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LibraryRecord) {
                    LibraryRecord libdisplay = (LibraryRecord)element;
                    return libdisplay.name();
                }
                return "";
            }
        });
    }

    private static void createLibraryFirstColumn(TreeViewerColumn col1, TreeViewerColumn col2) {
        col1.getColumn().setText(Messages.LibraryPage_Name);
        col1.getColumn().setWidth(150);
        col1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    String elem = (String)element;
                    return elem;
                }
                return "";
            }

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof String) {
                    String item = (String)element;
                    cell.setImage(null);
                    cell.setText(item);
                }
            }
        });
        col2.getColumn().setText(Messages.LibraryPage_Version);
        col2.getColumn().setWidth(100);
        col2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LibraryRecord) {
                    LibraryRecord libdisplay = (LibraryRecord)element;
                    return libdisplay.version().toString();
                }
                return "";
            }
        });
    }
}

