/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.ui.editors.AbstractBreadCrumbEditor;
import org.eclipse.fordiac.ide.model.ui.editors.GraphicalViewerNavigationLocationData;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.NavigationLocation;

public class BreadcrumbNavigationLocation
extends NavigationLocation {
    private final String breadcrumbPath;
    private GraphicalViewerNavigationLocationData viewerData = null;

    protected BreadcrumbNavigationLocation(AbstractBreadCrumbEditor editorPart) {
        super((IEditorPart)editorPart);
        this.breadcrumbPath = editorPart.getBreadcrumb().serializePath();
        GraphicalViewer viewer = editorPart.getAdapter(GraphicalViewer.class);
        if (viewer != null) {
            this.viewerData = new GraphicalViewerNavigationLocationData(viewer);
        }
    }

    public String getText() {
        String breadCrumbPath = BreadcrumbNavigationLocation.generateItemPath(this.breadcrumbPath).substring(1);
        if (this.viewerData != null && this.viewerData.getSelectedElementQN() != null) {
            return breadCrumbPath.split("\\.")[0] + "." + this.viewerData.getSelectedElementQN();
        }
        return breadCrumbPath;
    }

    public static String generateItemPath(String breadcrumbPath) {
        return breadcrumbPath.replace('/', '.');
    }

    private String getBreadCrumbPath() {
        return this.breadcrumbPath;
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
    }

    public void restoreLocation() {
        IEditorPart iEditorPart = this.getEditorPart();
        if (iEditorPart instanceof AbstractBreadCrumbEditor) {
            AbstractBreadCrumbEditor breadcrumbEditor = (AbstractBreadCrumbEditor)iEditorPart;
            breadcrumbEditor.getBreadcrumb().validateAndOpenPath(this.breadcrumbPath, (INamedElement)breadcrumbEditor.getAdapter(LibraryElement.class));
            GraphicalViewer viewer = breadcrumbEditor.getAdapter(GraphicalViewer.class);
            if (viewer != null && this.viewerData != null) {
                this.viewerData.restoreGraphicalViewerData((IEditorPart)breadcrumbEditor, (EditPartViewer)viewer);
            }
        }
    }

    public boolean mergeInto(INavigationLocation currentLocation) {
        BreadcrumbNavigationLocation loc;
        if (currentLocation instanceof BreadcrumbNavigationLocation && this.breadcrumbPath.equals((loc = (BreadcrumbNavigationLocation)currentLocation).getBreadCrumbPath())) {
            if (this.viewerData != null) {
                return this.viewerData.equals(loc.viewerData);
            }
            return true;
        }
        return false;
    }

    public void update() {
    }
}

