/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import com.google.common.collect.Maps;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaObjectNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class ObjectTypeManager {
    private final ConcurrentMap<NodeId, ObjectTypeDefinition> typeDefinitions = Maps.newConcurrentMap();

    public void registerObjectType(NodeId typeDefinition, Class<? extends UaObjectNode> nodeClass, ObjectNodeConstructor objectNodeConstructor) {
        this.typeDefinitions.put(typeDefinition, new ObjectTypeDefinition(nodeClass, objectNodeConstructor));
    }

    public Optional<ObjectNodeConstructor> getNodeConstructor(NodeId typeDefinition) {
        ObjectTypeDefinition def = (ObjectTypeDefinition)this.typeDefinitions.get(typeDefinition);
        return Optional.ofNullable(def).map(d -> d.nodeFactory);
    }

    @FunctionalInterface
    public static interface ObjectNodeConstructor {
        public UaObjectNode apply(OpcUaClient var1, NodeId var2, NodeClass var3, QualifiedName var4, LocalizedText var5, LocalizedText var6, UInteger var7, UInteger var8, UByte var9);
    }

    private static class ObjectTypeDefinition {
        final Class<? extends UaNode> nodeClass;
        final ObjectNodeConstructor nodeFactory;

        private ObjectTypeDefinition(Class<? extends UaNode> nodeClass, ObjectNodeConstructor nodeFactory) {
            this.nodeClass = nodeClass;
            this.nodeFactory = nodeFactory;
        }
    }
}

