/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client.transport.uasc;

import com.digitalpetri.netty.fsm.ChannelActions;
import com.digitalpetri.netty.fsm.ChannelFsm;
import com.digitalpetri.netty.fsm.ChannelFsmConfig;
import com.digitalpetri.netty.fsm.ChannelFsmFactory;
import com.digitalpetri.netty.fsm.Event;
import com.digitalpetri.netty.fsm.State;
import com.digitalpetri.strictmachine.FsmContext;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.milo.opcua.stack.client.UaStackClient;
import org.eclipse.milo.opcua.stack.client.UaStackClientConfig;
import org.eclipse.milo.opcua.stack.client.transport.tcp.OpcClientTcpChannelInitializer;
import org.eclipse.milo.opcua.stack.client.transport.uasc.ClientSecureChannel;
import org.eclipse.milo.opcua.stack.client.transport.websocket.OpcClientWebSocketChannelInitializer;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSecureChannelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientChannelFsm {
    private static final String CHANNEL_FSM_LOGGER_NAME = "org.eclipse.milo.opcua.stack.client.ChannelFsm";

    public static ChannelFsm newChannelFsm(UaStackClient client) {
        ChannelFsmConfig fsmConfig = ChannelFsmConfig.newBuilder().setLazy(false).setMaxIdleSeconds(0).setMaxReconnectDelaySeconds(16).setPersistent(true).setChannelActions((ChannelActions)new ClientChannelActions(client)).setExecutor((Executor)client.getConfig().getExecutor()).setScheduler(client.getConfig().getScheduledExecutor()).setLoggerName(CHANNEL_FSM_LOGGER_NAME).build();
        ChannelFsmFactory fsmFactory = new ChannelFsmFactory(fsmConfig);
        return fsmFactory.newChannelFsm();
    }

    private static class ClientChannelActions
    implements ChannelActions {
        private static final Logger LOGGER = LoggerFactory.getLogger((String)"org.eclipse.milo.opcua.stack.client.ChannelFsm");
        private final UaStackClientConfig config;
        private final UaStackClient client;

        ClientChannelActions(UaStackClient client) {
            this.client = client;
            this.config = client.getConfig();
        }

        public CompletableFuture<Channel> connect(FsmContext<State, Event> ctx) {
            CompletableFuture<ClientSecureChannel> handshake = new CompletableFuture<ClientSecureChannel>();
            String transportProfileUri = this.config.getEndpoint().getTransportProfileUri();
            TransportProfile transportProfile = TransportProfile.fromUri((String)transportProfileUri);
            ChannelInitializer initializer = transportProfile == TransportProfile.TCP_UASC_UABINARY ? new OpcClientTcpChannelInitializer(this.client, handshake) : new OpcClientWebSocketChannelInitializer(this.client, handshake);
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)this.config.getEventLoop())).channel(NioSocketChannel.class)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.config.getConnectTimeout().intValue())).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)initializer);
            try {
                String endpointUrl = this.config.getEndpoint().getEndpointUrl();
                String host = EndpointUtil.getHost((String)endpointUrl);
                assert (host != null);
                int port = EndpointUtil.getPort((String)endpointUrl);
                bootstrap.connect(host, port).addListener(f -> {
                    if (!f.isSuccess()) {
                        Throwable cause = f.cause();
                        if (cause instanceof ConnectTimeoutException) {
                            handshake.completeExceptionally((Throwable)new UaException(0x800A0000L, f.cause()));
                        } else if (cause instanceof ConnectException) {
                            handshake.completeExceptionally((Throwable)new UaException(2158755840L, f.cause()));
                        } else {
                            handshake.completeExceptionally(cause);
                        }
                    }
                });
            }
            catch (Throwable e) {
                UaException failure = new UaException(0x80830000L, e);
                handshake.completeExceptionally((Throwable)failure);
            }
            return handshake.thenApply(ClientSecureChannel::getChannel);
        }

        public CompletableFuture<Void> disconnect(final FsmContext<State, Event> ctx, Channel channel) {
            final CompletableFuture<Void> disconnectFuture = new CompletableFuture<Void>();
            TimerTask onTimeout = t -> channel.close().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> disconnectFuture.complete(null)));
            final Timeout timeout = this.config.getWheelTimer().newTimeout(onTimeout, 5L, TimeUnit.SECONDS);
            channel.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                public void channelInactive(ChannelHandlerContext channelContext) throws Exception {
                    LOGGER.debug("[{}] channelInactive() disconnect complete", (Object)ctx.getInstanceId());
                    timeout.cancel();
                    disconnectFuture.complete(null);
                    super.channelInactive(channelContext);
                }
            }});
            RequestHeader requestHeader = new RequestHeader(NodeId.NULL_VALUE, DateTime.now(), Unsigned.uint((int)0), Unsigned.uint((int)0), null, Unsigned.uint((int)0), null);
            LOGGER.debug("[{}] Sending CloseSecureChannelRequest...", (Object)ctx.getInstanceId());
            channel.pipeline().fireUserEventTriggered((Object)new CloseSecureChannelRequest(requestHeader));
            return disconnectFuture;
        }

        public CompletableFuture<Void> keepAlive(FsmContext<State, Event> ctx, Channel channel) {
            return CompletableFuture.completedFuture(null);
        }
    }
}

