/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui.handler;

import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.deployment.debug.ui.annotation.WatchValueAnnotation;
import org.eclipse.fordiac.ide.deployment.debug.ui.editparts.AbstractWatchValueEditPart;
import org.eclipse.fordiac.ide.deployment.debug.ui.editparts.WatchValueEditPart;
import org.eclipse.fordiac.ide.deployment.debug.watch.IInterfaceElementWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.IVarDeclarationWatch;
import org.eclipse.fordiac.ide.model.commands.change.ChangeValueCommand;
import org.eclipse.fordiac.ide.model.data.BoolType;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkElementHelper;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementProvider;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceStoreProvider;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ToggleBoolValueHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        CommandStack stack = (CommandStack)editor.getAdapter(CommandStack.class);
        boolean writeThrough = ToggleBoolValueHandler.getMonitoringValueWriteThrough(editor);
        ToggleBoolValueHandler.getValues(HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event)).forEachOrdered(value -> ToggleBoolValueHandler.toggleValue(value, stack, writeThrough));
        return null;
    }

    private static void toggleValue(WatchValueAnnotation annotation, CommandStack stack, boolean monitoringValueWriteThrough) {
        IInterfaceElementWatch iInterfaceElementWatch;
        VarDeclaration varDeclaration;
        IInterfaceElement iInterfaceElement = annotation.getElement();
        if (iInterfaceElement instanceof VarDeclaration && (varDeclaration = (VarDeclaration)iInterfaceElement).isIsInput() && varDeclaration.getType() instanceof BoolType && !varDeclaration.isArray() && (iInterfaceElementWatch = annotation.getWatch()) instanceof IVarDeclarationWatch) {
            IVarDeclarationWatch varDeclarationWatch = (IVarDeclarationWatch)iInterfaceElementWatch;
            String newValue = Boolean.parseBoolean(annotation.getText()) ? "FALSE" : "TRUE";
            try {
                varDeclarationWatch.setValue(newValue);
            }
            catch (DebugException e) {
                ErrorDialog.openError(null, null, null, (IStatus)Status.error((String)e.getLocalizedMessage(), (Throwable)e));
            }
            if (stack != null && monitoringValueWriteThrough && !FBNetworkElementHelper.isContainedInTypedInstance((EObject)varDeclaration.getBlockFBNetworkElement())) {
                stack.execute((Command)new ChangeValueCommand(varDeclaration, newValue));
            }
        }
    }

    public void setEnabled(Object evaluationContext) {
        IStructuredSelection selection;
        Object object = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        this.setBaseEnabled(object instanceof IStructuredSelection && ToggleBoolValueHandler.getValues(selection = (IStructuredSelection)object).allMatch(ToggleBoolValueHandler::isValidValue));
    }

    private static boolean isValidValue(WatchValueAnnotation annotation) {
        VarDeclaration varDeclaration;
        IInterfaceElement iInterfaceElement = annotation.getElement();
        return iInterfaceElement instanceof VarDeclaration && (varDeclaration = (VarDeclaration)iInterfaceElement).isIsInput() && varDeclaration.getType() instanceof BoolType && !varDeclaration.isArray();
    }

    private static Stream<WatchValueAnnotation> getValues(IStructuredSelection selection) {
        return selection.stream().filter(WatchValueEditPart.class::isInstance).map(WatchValueEditPart.class::cast).map(AbstractWatchValueEditPart::getModel);
    }

    private static boolean getMonitoringValueWriteThrough(IEditorPart editor) {
        LibraryElement libraryElement = LibraryElementProvider.INSTANCE.getLibraryElement(editor.getEditorInput());
        if (libraryElement != null && libraryElement.getTypeLibrary() != null) {
            return PreferenceStoreProvider.getStore((String)"org.eclipse.fordiac.ide.deployment.debug", (IProject)libraryElement.getTypeLibrary().getProject()).getBoolean("monitoringValueWriteThrough");
        }
        return false;
    }
}

