/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.ui.wizard;

import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.export.ui.Messages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ExportStatusMessageDialog
extends ErrorDialog {
    private final List<String> warnings;
    private final List<String> errors;
    private final List<String> infos;
    private StyledText text;

    public ExportStatusMessageDialog(Shell parentShell, List<String> warnings, List<String> errors, List<String> infos) {
        super(parentShell, Messages.ExportStatusMessageDialog_4diacIDETypeExportErrors, Messages.ExportStatusMessageDialog_DuringTypeExportTheFollowingIssuesHaveBeenIdentified, (IStatus)new Status(1, "org.eclipse.fordiac.ide.export", MessageFormat.format(Messages.ExportStatusMessageDialog_ExportStatusMessageDialog, errors.size(), warnings.size(), infos.size())), 7);
        this.warnings = warnings;
        this.errors = errors;
        this.infos = infos;
    }

    protected void createDialogAndButtonArea(Composite parent) {
        super.createDialogAndButtonArea(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.dialogArea);
    }

    protected Control createMessageArea(Composite parent) {
        Control retval = super.createMessageArea(parent);
        ExportStatusMessageDialog.addPlaceholderLabel(parent);
        this.text = new StyledText(parent, 2818);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.text);
        this.text.setEditable(false);
        this.printMessages();
        return retval;
    }

    private static void addPlaceholderLabel(Composite parent) {
        new Label(parent, 0);
    }

    public void printMessages() {
        this.text.setText("");
        if (!this.errors.isEmpty()) {
            this.printMessageList(Messages.ExportStatusMessageDialog_ErrorsNotEmpty, this.errors);
        }
        if (!this.warnings.isEmpty()) {
            this.printMessageList(Messages.ExportStatusMessageDialog_WarningsNotEmpty, this.warnings);
        }
        if (!this.infos.isEmpty()) {
            this.printMessageList(Messages.ExportStatusMessageDialog_InfosNotEmpty, this.infos);
        }
    }

    private void printMessageList(String title, List<String> messages) {
        StyleRange titleStyle = new StyleRange();
        titleStyle.start = this.text.getCharCount();
        titleStyle.length = title.length();
        titleStyle.fontStyle = 1;
        this.text.append(title);
        this.text.setStyleRange(titleStyle);
        this.text.append(messages.stream().filter(Objects::nonNull).map("    - "::concat).collect(Collectors.joining("\n", "", "\n\n")));
    }
}

