/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotation;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotationModel;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;

public abstract class AbstractAnnotatedConfigLabelAccumulator<T>
implements IConfigLabelAccumulator {
    private final IRowDataProvider<T> dataProvider;
    private final Supplier<GraphicalAnnotationModel> annotationModelSupplier;

    protected AbstractAnnotatedConfigLabelAccumulator(IRowDataProvider<T> dataProvider, Supplier<GraphicalAnnotationModel> annotationModelSupplier) {
        this.dataProvider = dataProvider;
        this.annotationModelSupplier = annotationModelSupplier;
    }

    protected void accumulateAttributeConfigLabels(LabelStack configLabels, Object target) {
        this.accumulateAttributeConfigLabels(configLabels, target, annotation -> true);
    }

    protected void accumulateAttributeConfigLabels(LabelStack configLabels, Object target, Predicate<GraphicalAnnotation> filter) {
        GraphicalAnnotationModel annotationModel = this.getAnnotationModel();
        if (annotationModel == null) {
            return;
        }
        if (annotationModel.hasAnnotation(target, "org.eclipse.fordiac.ide.model.ui.annotation.error", filter)) {
            configLabels.addLabelOnTop("ERROR_CELL");
        } else if (annotationModel.hasAnnotation(target, "org.eclipse.fordiac.ide.model.ui.annotation.warning", filter)) {
            configLabels.addLabelOnTop("WARNING_CELL");
        }
    }

    public IRowDataProvider<T> getDataProvider() {
        return this.dataProvider;
    }

    public GraphicalAnnotationModel getAnnotationModel() {
        return this.annotationModelSupplier.get();
    }

    public Supplier<GraphicalAnnotationModel> getAnnotationModelSupplier() {
        return this.annotationModelSupplier;
    }
}

