/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.tools;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.gef.utilities.CollisionChangeBoundsRequest;
import org.eclipse.fordiac.ide.gef.utilities.TrackerMarginBoundsHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;

public class ScrollingDragEditPartsTracker
extends DragEditPartsTracker {
    private final TrackerMarginBoundsHelper boundsHelper = new TrackerMarginBoundsHelper();
    EditPartViewer initialViewer;

    public ScrollingDragEditPartsTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    protected Request createTargetRequest() {
        if (this.isCloneActive()) {
            return new ChangeBoundsRequest((Object)"clone");
        }
        return new CollisionChangeBoundsRequest("move", this.boundsHelper.getFigures(), this.boundsHelper.getParentFigure());
    }

    protected boolean handleDragStarted() {
        this.initialViewer = this.getCurrentViewer();
        this.boundsHelper.initDrag(this.getSourceEditPart(), this.getCurrentViewer().getSelectedEditParts());
        return super.handleDragStarted();
    }

    protected void setCloneActive(boolean cloneActive) {
        super.setCloneActive(cloneActive);
        this.boundsHelper.createFigures(this.getTargetEditPart());
    }

    protected void eraseSourceFeedback() {
        this.boundsHelper.clearFigureList();
        super.eraseSourceFeedback();
    }

    protected void showSourceFeedback() {
        if (this.differentTargetViewer()) {
            Point location = this.getLocation();
            Point converted = new Point(this.initialViewer.getControl().toControl(this.getCurrentViewer().getControl().toDisplay(location.x, location.y)));
            this.getTargetRequest().setLocation(converted);
            this.getTargetRequest().getExtendedData().clear();
            Dimension moveDelta = this.getLocation().getDifference(converted);
            this.getTargetRequest().setMoveDelta(new Point(moveDelta));
            this.snapPoint(this.getTargetRequest());
        }
        this.boundsHelper.createFigures(this.getTargetEditPart());
        super.showSourceFeedback();
        if (this.differentTargetViewer()) {
            this.updateTargetRequest();
        }
    }

    private boolean differentTargetViewer() {
        return this.initialViewer != null && this.initialViewer != this.getCurrentViewer();
    }
}

