/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.commands.BorderCrossingReconnectCommand;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.QualNameAffectedCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.RemoveElementsFromGroup;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class MoveAndReconnectCommand
extends Command
implements QualNameAffectedCommand {
    protected final FBNetwork sourceNetwork;
    private Position destination;
    private final FBNetwork destinationNetwork;
    protected final List<FBNetworkElement> elements;
    private final Map<FBNetworkElement, Position> oldPos = new HashMap<FBNetworkElement, Position>();
    private final Map<FBNetworkElement, Position> newPos = new HashMap<FBNetworkElement, Position>();
    private final CompoundCommand unmappingCmds = new CompoundCommand();
    private final CompoundCommand setUniqueName = new CompoundCommand();
    private final CompoundCommand removeFromGroup = new CompoundCommand();
    private CompoundCommand reconnectConnectionsCommands = null;
    private final Map<INamedElement, String> oldQualNames = new HashMap<INamedElement, String>();
    private final Map<INamedElement, String> newQualNames = new HashMap<INamedElement, String>();

    public MoveAndReconnectCommand(Collection<FBNetworkElement> elements, Point destination) {
        this(elements, destination, null);
    }

    public MoveAndReconnectCommand(Collection<FBNetworkElement> elements, Point destination, FBNetwork destinationNetwork) {
        this.elements = new ArrayList<FBNetworkElement>(elements);
        this.setDestination(destination);
        this.sourceNetwork = this.getSourceNetwork();
        if (destinationNetwork == null) {
            EObject eObject;
            if (this.sourceNetwork != null && (eObject = this.sourceNetwork.eContainer()) instanceof SubApp) {
                SubApp subapp = (SubApp)eObject;
                this.destinationNetwork = subapp.getFbNetwork();
            } else {
                this.destinationNetwork = null;
            }
        } else {
            this.destinationNetwork = destinationNetwork;
        }
    }

    private FBNetwork getSourceNetwork() {
        return this.elements.isEmpty() ? null : this.elements.get(0).getFbNetwork();
    }

    public boolean canExecute() {
        return this.destinationNetwork != null && this.destinationNetwork != this.sourceNetwork && this.allElementsFromSameNetwork() && !this.destinationNetworkChildOfElements();
    }

    private boolean allElementsFromSameNetwork() {
        return this.elements.stream().allMatch(el -> this.sourceNetwork.equals(el.getFbNetwork()));
    }

    private boolean destinationNetworkChildOfElements() {
        EObject obj = this.destinationNetwork.eContainer();
        while (obj != null) {
            if (this.elements.contains(obj)) {
                return true;
            }
            obj = obj.eContainer();
        }
        return false;
    }

    public void execute() {
        this.storeOldQualNames();
        this.removeElementsFromGroup();
        this.removeElementsFromSubapp();
        this.addElementsToDestination();
        this.reconnectConnections();
        this.storeNewQualNames();
    }

    private void storeNewQualNames() {
        this.elements.forEach(e -> {
            String string = this.newQualNames.put((INamedElement)e, e.getQualifiedName());
        });
    }

    private void storeOldQualNames() {
        this.elements.forEach(e -> {
            String string = this.oldQualNames.put((INamedElement)e, e.getQualifiedName());
        });
    }

    private void removeElementsFromGroup() {
        this.elements.forEach(element -> {
            RemoveElementsFromGroup cmd = new RemoveElementsFromGroup(Arrays.asList(element));
            this.removeFromGroup.add((Command)cmd);
        });
        this.removeFromGroup.execute();
    }

    protected void removeElementsFromSubapp() {
        this.elements.forEach(this::removeElementFromSubapp);
        this.elements.forEach(this::removeContainedGroupElementsFromSubapp);
    }

    private void removeContainedGroupElementsFromSubapp(FBNetworkElement el) {
        if (el instanceof Group) {
            Group group = (Group)el;
            group.getGroupElements().forEach(this::removeElementFromSubapp);
        }
    }

    private void removeElementFromSubapp(FBNetworkElement element) {
        UnmapCommand cmd;
        this.oldPos.put(element, element.getPosition());
        if (element.isMapped() && (cmd = new UnmapCommand(element)).canExecute()) {
            cmd.execute();
            this.unmappingCmds.add((Command)cmd);
        }
        this.sourceNetwork.getNetworkElements().remove((Object)element);
    }

    protected void addElementsToDestination() {
        this.elements.forEach(this::addElementToDestination);
        this.elements.forEach(this::addGroupElements);
        this.positionElements();
    }

    private void addElementToDestination(FBNetworkElement element) {
        this.destinationNetwork.getNetworkElements().add((Object)element);
        if (!NameRepository.isValidName((INamedElement)element, (String)element.getName())) {
            String uniqueName = NameRepository.createUniqueName((INamedElement)element, (String)element.getName());
            ChangeNameCommand changeNameCommand = ChangeNameCommand.forName((INamedElement)element, (String)uniqueName);
            changeNameCommand.execute();
            this.setUniqueName.add((Command)changeNameCommand);
        }
    }

    private void addGroupElements(FBNetworkElement el) {
        if (el instanceof Group) {
            Group group = (Group)el;
            group.getGroupElements().forEach(this::addElementToDestination);
        }
    }

    private void reconnectConnections() {
        this.reconnectConnectionsCommands = MoveAndReconnectCommand.createReconnectCommand(this.elements);
        this.reconnectConnectionsCommands.execute();
    }

    public void redo() {
        this.removeFromGroup.redo();
        this.redoRemoveElementsFromSubapp();
        this.redoAddElementsToDestination();
        this.reconnectConnectionsCommands.redo();
    }

    protected void redoRemoveElementsFromSubapp() {
        this.unmappingCmds.redo();
        this.elements.forEach(this::redoRemoveElementFromSubapp);
    }

    private void redoRemoveElementFromSubapp(FBNetworkElement element) {
        this.sourceNetwork.getNetworkElements().remove((Object)element);
    }

    protected void redoAddElementsToDestination() {
        this.elements.forEach(this::redoAddElementToDestination);
        this.setUniqueName.redo();
    }

    private void redoAddElementToDestination(FBNetworkElement element) {
        this.destinationNetwork.getNetworkElements().add((Object)element);
        element.setPosition(this.newPos.get(element));
    }

    public void undo() {
        this.reconnectConnectionsCommands.undo();
        this.undoRemoveElementsFromSubapp();
        this.undoAddElementsToDestination();
        this.removeFromGroup.undo();
    }

    protected void undoRemoveElementsFromSubapp() {
        this.elements.forEach(this::undoRemoveElementFromSubapp);
        this.unmappingCmds.undo();
        FBNetworkHelper.getBlockFBNetworkElementsFromList(this.elements).forEach(BlockFBNetworkElement::checkConnections);
    }

    private void undoRemoveElementFromSubapp(FBNetworkElement element) {
        this.newPos.put(element, element.getPosition());
        this.sourceNetwork.getNetworkElements().add((Object)element);
    }

    protected void undoAddElementsToDestination() {
        this.setUniqueName.undo();
        this.elements.forEach(this::undoAddElementToDestination);
    }

    private void undoAddElementToDestination(FBNetworkElement element) {
        this.destinationNetwork.getNetworkElements().remove((Object)element);
        element.setPosition(this.oldPos.get(element));
    }

    public List<FBNetworkElement> getElements() {
        return this.elements;
    }

    private void positionElements() {
        if (this.destination == null) {
            EObject eObject = this.destinationNetwork.eContainer();
            if (eObject instanceof SubApp) {
                SubApp subapp = (SubApp)eObject;
                this.destination = subapp.getPosition();
            } else {
                this.destination = LibraryElementFactory.eINSTANCE.createPosition();
            }
        }
        FBNetworkHelper.moveFBNetworkToDestination(this.elements, (Position)this.destination);
    }

    private static CompoundCommand createReconnectCommand(List<FBNetworkElement> fbElements) {
        CompoundCommand cmd = new CompoundCommand();
        FBNetworkHelper.getBlockFBNetworkElementsFromList(fbElements).forEach(fbElement -> fbElement.getInterface().getAllInterfaceElements().forEach(ie -> {
            if (ie.isIsInput()) {
                ie.getInputConnections().stream().filter(conn -> !fbElements.contains(conn.getSource().getBlockFBNetworkElement())).forEach(conn -> cmd.add((Command)new BorderCrossingReconnectCommand(conn.getDestination(), conn.getDestination(), (Connection)conn, false)));
            } else {
                ie.getOutputConnections().stream().forEach(conn -> cmd.add((Command)new BorderCrossingReconnectCommand(conn.getSource(), conn.getSource(), (Connection)conn, true)));
            }
        }));
        return cmd;
    }

    protected final void setDestination(Point destination) {
        this.destination = CoordinateConverter.INSTANCE.createPosFromScreenCoordinates(destination.x, destination.y);
    }

    public Set<EObject> getAffectedObjects() {
        if (this.sourceNetwork != null && this.destinationNetwork != null) {
            return Set.of(this.sourceNetwork, this.destinationNetwork);
        }
        return Set.of();
    }

    public String getOldQualName(INamedElement element) {
        return this.oldQualNames.get(element);
    }

    public String getNewQualName(INamedElement element) {
        return this.newQualNames.get(element);
    }

    public List<INamedElement> getChangedElements() {
        return new ArrayList<FBNetworkElement>(this.elements);
    }
}

