/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;

public class FBNetworkConnectionLabel
extends Figure
implements RotatableDecoration {
    public static final int HIDDEN_CON_LABEL_ALPHA = 150;
    private final Label label;
    private final boolean srcLabel;

    public FBNetworkConnectionLabel(boolean srcLabel) {
        this.srcLabel = srcLabel;
        this.setLayoutManager((LayoutManager)new ToolbarLayout(true));
        RoundedRectangle rect = FBNetworkConnectionLabel.createBaseShape();
        this.add((IFigure)rect);
        this.label = FBNetworkConnectionLabel.createLabel();
        rect.add((IFigure)this.label);
    }

    protected static RoundedRectangle createBaseShape() {
        RoundedRectangle rect = new RoundedRectangle();
        rect.setLayoutManager((LayoutManager)new StackLayout());
        rect.setFill(true);
        rect.setAntialias(1);
        rect.setOutline(false);
        rect.setCornerDimensions(new Dimension(10, 10));
        rect.setAlpha(150);
        return rect;
    }

    protected boolean isSrcLabel() {
        return this.srcLabel;
    }

    private static Label createLabel() {
        Label label = new Label();
        label.setOpaque(false);
        label.setForegroundColor(ColorConstants.white);
        label.setFont(FBNetworkConnectionLabel.getLabelFont());
        label.setBorder((Border)new MarginBorder(0, 2, 0, 2));
        return label;
    }

    public Label getLabel() {
        return this.label;
    }

    private static Font getLabelFont() {
        return JFaceResources.getFontRegistry().get("org.eclipse.fordiac.ide.preferences.diagramFontDefinition");
    }

    public void setReferencePoint(Point p) {
    }

    public void setLocation(Point p) {
        Dimension preferredSize = super.getPreferredSize();
        if (!this.srcLabel) {
            p.x -= preferredSize.width;
        }
        p.y -= preferredSize.height / 2;
        super.setBounds(new Rectangle(p, preferredSize));
    }
}

