/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.application.commands.ConvertSubappToGroupCommand;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.application.editparts.UISubAppNetworkEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConvertToGroupHandler
extends AbstractHandler
implements CommandStackEventListener {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        SubApp subApp = ConvertToGroupHandler.getSelectedSubApp(selection);
        if (subApp != null) {
            CommandStack commandStack = HandlerHelper.getCommandStack((IEditorPart)editor);
            ConvertSubappToGroupCommand cmd = new ConvertSubappToGroupCommand(subApp);
            if (cmd.canExecute()) {
                commandStack.execute((Command)cmd);
            }
            commandStack.addCommandStackEventListener((CommandStackEventListener)this);
        }
        return Status.OK_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        SubApp subApp = ConvertToGroupHandler.getSelectedSubApp(selection);
        this.setBaseEnabled(subApp != null && !subApp.isTyped() && !subApp.isContainedInTypedInstance() && !ConvertToGroupHandler.isGroupContainedInSubapp(subApp));
    }

    private static boolean isGroupContainedInSubapp(SubApp subApp) {
        FBNetworkElement group = subApp.getSubAppNetwork().getNetworkElements().stream().filter(Group.class::isInstance).findFirst().orElse(null);
        return group != null;
    }

    private static SubApp getSelectedSubApp(Object selection) {
        IStructuredSelection structSel;
        if (selection instanceof IStructuredSelection && !(structSel = (IStructuredSelection)selection).isEmpty() && structSel.size() == 1) {
            SubApp subApp = ConvertToGroupHandler.getSubApp(structSel.getFirstElement());
            return subApp != null && subApp.isMapped() ? (SubApp)subApp.getMapping().getFrom() : subApp;
        }
        return null;
    }

    private static SubApp getSubApp(Object currentElement) {
        Object object = currentElement;
        Objects.requireNonNull(object);
        Object object2 = object;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SubApp.class, SubAppForFBNetworkEditPart.class, UISubAppNetworkEditPart.class}, (Object)object2, 0)) {
            case 0 -> {
                SubApp subApp;
                yield subApp = (SubApp)object2;
            }
            case 1 -> {
                SubAppForFBNetworkEditPart subAppEP = (SubAppForFBNetworkEditPart)object2;
                yield subAppEP.getModel();
            }
            case 2 -> {
                UISubAppNetworkEditPart uiSubAppEp = (UISubAppNetworkEditPart)((Object)object2);
                yield (SubApp)uiSubAppEp.getModel().eContainer();
            }
            default -> null;
        };
    }

    public void stackChanged(CommandStackEvent event) {
    }
}

