/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.marker.resolution;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.marker.resolution.ChangeNameMarkerResolution;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public class ChangeFileNameMarkerResolution
extends ChangeNameMarkerResolution {
    public ChangeFileNameMarkerResolution(IMarker marker) {
        super(marker);
    }

    public String getDescription() {
        return Messages.ChangeFileNameToType_QuickfixDesc;
    }

    public String getLabel() {
        return Messages.ChangeFileNameToType_QuickfixLabel;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void runInWorkspace(IMarker marker) throws CoreException {
        void file;
        IResource iResource = marker.getResource();
        if (!(iResource instanceof IFile)) {
            throw ChangeFileNameMarkerResolution.createExceptionForMarker(Messages.ChangeName_NoFileError, marker);
        }
        IFile iFile = (IFile)iResource;
        TypeEntry typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile((IFile)file);
        if (typeEntry == null) {
            throw ChangeFileNameMarkerResolution.createExceptionForMarker(Messages.ChangeName_NoTypeEntryError, marker);
        }
        TypeLibrary typeLibrary = typeEntry.getTypeLibrary();
        typeLibrary.removeTypeEntry(typeEntry);
        IPath path = marker.getResource().getFullPath();
        IPath newPath = path.removeLastSegments(1).append(typeEntry.getTypeName()).addFileExtension(typeEntry.getFileExtension());
        marker.getResource().move(newPath, false, (IProgressMonitor)new NullProgressMonitor());
        typeEntry.setFile(file.getWorkspace().getRoot().getFile(newPath));
        typeLibrary.addTypeEntry(typeEntry);
    }
}

