/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.orthogonal.direction;

import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegment;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.direction.BaseRoutingDirectionStrategy;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;

class WestToEastRoutingStrategy
extends BaseRoutingDirectionStrategy {
    WestToEastRoutingStrategy() {
    }

    @Override
    public double getPortPositionOnHyperNode(LPort port) {
        return port.getNode().getPosition().y + port.getPosition().y + port.getAnchor().y;
    }

    @Override
    public PortSide getSourcePortSide() {
        return PortSide.EAST;
    }

    @Override
    public PortSide getTargetPortSide() {
        return PortSide.WEST;
    }

    @Override
    public void calculateBendPoints(HyperEdgeSegment segment, double startPos, double edgeSpacing) {
        if (segment.isDummy()) {
            return;
        }
        double segmentX = startPos + (double)segment.getRoutingSlot() * edgeSpacing;
        for (LPort port : segment.getPorts()) {
            double sourceY = port.getAbsoluteAnchor().y;
            for (LEdge edge : port.getOutgoingEdges()) {
                if (edge.isSelfLoop()) continue;
                LPort target = edge.getTarget();
                double targetY = target.getAbsoluteAnchor().y;
                if (!(Math.abs(sourceY - targetY) > 0.001)) continue;
                double currentX = segmentX;
                HyperEdgeSegment currentSegment = segment;
                KVector bend = new KVector(currentX, sourceY);
                edge.getBendPoints().add((Object)bend);
                this.addJunctionPointIfNecessary(edge, currentSegment, bend, true);
                HyperEdgeSegment splitPartner = segment.getSplitPartner();
                if (splitPartner != null) {
                    double splitY = splitPartner.getIncomingConnectionCoordinates().get(0);
                    bend = new KVector(currentX, splitY);
                    edge.getBendPoints().add((Object)bend);
                    this.addJunctionPointIfNecessary(edge, currentSegment, bend, true);
                    currentX = startPos + (double)splitPartner.getRoutingSlot() * edgeSpacing;
                    currentSegment = splitPartner;
                    bend = new KVector(currentX, splitY);
                    edge.getBendPoints().add((Object)bend);
                    this.addJunctionPointIfNecessary(edge, currentSegment, bend, true);
                }
                bend = new KVector(currentX, targetY);
                edge.getBendPoints().add((Object)bend);
                this.addJunctionPointIfNecessary(edge, currentSegment, bend, true);
            }
        }
    }
}

