/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library.builder;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.fordiac.ide.library.LibraryManager;
import org.eclipse.fordiac.ide.library.Messages;
import org.eclipse.fordiac.ide.library.model.library.Manifest;
import org.eclipse.fordiac.ide.library.model.util.ManifestHelper;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;

public class LibraryBuilder
extends IncrementalProjectBuilder {
    private static final int MASK = 7;
    private final List<String> changedLibs = new LinkedList<String>();
    private final IResourceDeltaVisitor visitor = delta -> {
        switch (delta.getResource().getType()) {
            case 4: {
                IResource iResource = delta.getResource();
                if (iResource instanceof IProject) {
                    IProject project = (IProject)iResource;
                    if ((delta.getFlags() & 0x80000) != 0) {
                        this.changedLibs.add(project.getName());
                    }
                }
                return true;
            }
            case 1: {
                IFile file;
                IResource iResource = delta.getResource();
                if (iResource instanceof IFile && "MANIFEST.MF".equals((file = (IFile)iResource).getName()) && (file.isLinked() || delta.getKind() == 2) && (delta.getKind() & 7) != 0) {
                    this.changedLibs.add(file.getParent().getName());
                }
                return false;
            }
            case 2: {
                IResource iResource = delta.getResource();
                if (!(iResource instanceof IFolder)) break;
                IFolder folder = (IFolder)iResource;
                return LibraryBuilder.isLinkedLibraryFolder((IContainer)folder) || (folder.isLinked() || delta.getKind() == 2) && LibraryBuilder.isLinkedLibraryFolder(folder.getParent());
            }
        }
        return true;
    };

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LibraryBuilder_ResolveProjectDependencies, (int)1);
        IProject project = this.getProject();
        Manifest manifest = ManifestHelper.getContainerManifest((IContainer)project);
        if (manifest == null) {
            return new IProject[0];
        }
        if (kind == 6) {
            LibraryBuilder.fullBuild(project, manifest, (IProgressMonitor)progress.split(1));
        } else {
            IResourceDelta delta = this.getDelta(project);
            this.changedLibs.clear();
            if (delta != null) {
                delta.accept(this.visitor, 8);
                if (LibraryBuilder.projectManifestChanged(delta) || this.referencedManifestChanged() || !this.changedLibs.isEmpty()) {
                    LibraryBuilder.fullBuild(project, manifest, (IProgressMonitor)progress.split(1));
                }
            }
        }
        return project.getReferencedProjects();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LibraryBuilder_CleaningLibrary, (int)2);
        FordiacMarkerHelper.updateMarkers((IResource)this.getProject().getFile("MANIFEST.MF"), (String)"org.eclipse.fordiac.ide.model.library", Collections.emptyList(), (boolean)true);
        progress.worked(1);
        LibraryManager.LIBRARY_FOLDERS.stream().map(name -> this.getProject().getFolder(name)).forEach(folder -> FordiacMarkerHelper.updateMarkers((IResource)folder, (String)"org.eclipse.fordiac.ide.model.library", Collections.emptyList(), (boolean)true));
        progress.worked(1);
        SubMonitor.done((IProgressMonitor)monitor);
    }

    public ISchedulingRule getRule(int kind, Map<String, String> args) {
        return this.getProject();
    }

    private static void fullBuild(IProject project, Manifest manifest, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LibraryBuilder_LibraryBuild, (int)1);
        LibraryManager.INSTANCE.resolveDependencies(project, manifest, (IProgressMonitor)progress.split(1));
    }

    private boolean referencedManifestChanged() throws CoreException {
        return Stream.of(this.getProject().getReferencedProjects()).map(arg_0 -> ((LibraryBuilder)this).getDelta(arg_0)).filter(Objects::nonNull).anyMatch(LibraryBuilder::projectManifestChanged);
    }

    private static boolean projectManifestChanged(IResourceDelta delta) {
        IResourceDelta md = delta.findMember((IPath)new Path("MANIFEST.MF"));
        return md != null && (md.getKind() & 5) != 0;
    }

    private static boolean isLinkedLibraryFolder(IContainer container) {
        return container instanceof IFolder && container.getParent() instanceof IProject && ("Standard Libraries".equals(container.getName()) || "External Libraries".equals(container.getName()));
    }
}

