/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.fb.interpreter.inputgenerator.InputGenerator;
import org.eclipse.fordiac.ide.fb.interpreter.mm.ServiceSequenceUtils;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateRecordedServiceSequenceCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.handler.ServiceHandlerUtils;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.widgets.RecordSequenceDialog;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class RecordServiceSequenceHandler
extends AbstractHandler {
    private static final int CANCEL = -1;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ServiceSequence seq = ServiceHandlerUtils.getFirstSelectedSequence(selection);
        FBType type = ServiceHandlerUtils.getSelectedFbType(seq, selection);
        ArrayList<String> events = new ArrayList<String>();
        ArrayList<List<String>> parameters = new ArrayList<List<String>>();
        parameters.add(new ArrayList());
        RecordSequenceDialog dialog = new RecordSequenceDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), events, (List)parameters.get(0), type);
        int returnCode = dialog.open();
        if (returnCode != -1) {
            RecordServiceSequenceHandler.addRandomElements(type, events, parameters, dialog);
            try {
                CreateRecordedServiceSequenceCommand recordCmd = new CreateRecordedServiceSequenceCommand(type, seq, events, parameters, !dialog.isAppend());
                recordCmd.setStartState(dialog.getStartState());
                CommandStack cmdstack = (CommandStack)HandlerUtil.getActiveEditor((ExecutionEvent)event).getAdapter(CommandStack.class);
                if (recordCmd.canExecute()) {
                    cmdstack.execute((Command)recordCmd);
                }
            }
            catch (Exception e) {
                MessageDialog.openWarning((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.RecordServiceSequenceHandler_PROBLEM, (String)Messages.RecordServiceSequenceHandler_CHECK_VARIABLE_NAMES);
            }
        }
        return Status.OK_STATUS;
    }

    private static void addRandomElements(FBType type, List<String> eventNames, List<List<String>> parameterStrings, RecordSequenceDialog dialog) {
        if (dialog.isRandomEventBoxChecked()) {
            List randomEvents = InputGenerator.getRandomEventsSequence((FBType)type, (int)dialog.getCount());
            eventNames.addAll(randomEvents.stream().map(INamedElement::getName).toList());
        }
        if (dialog.isRandomParameterBoxChecked() && dialog.getCount() > 0) {
            List allEvents = ServiceSequenceUtils.getEvents((FBType)type, eventNames);
            if (parameterStrings.get(0).isEmpty()) {
                parameterStrings.get(0).addAll(RecordServiceSequenceHandler.getRandomParameterStrings((Event)allEvents.get(0)));
            }
            for (Event e : allEvents.subList(1, allEvents.size())) {
                parameterStrings.add(RecordServiceSequenceHandler.getRandomParameterStrings(e));
            }
        }
    }

    private static List<String> getRandomParameterStrings(Event e) {
        List randomData = InputGenerator.getRandomData((Event)e);
        String parameter = ServiceSequenceUtils.summarizeParameters((Iterable)randomData);
        return ServiceSequenceUtils.splitList((String)parameter);
    }

    public void setEnabled(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            this.setBaseEnabled(structuredSelection.size() <= 1);
        }
    }
}

