/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.fordiac.ide.model.ui.Messages;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementActivationListener;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class MultiLibraryElementActivationListener
extends LibraryElementActivationListener {
    private final Set<IEditorInput> editorInputs;

    public MultiLibraryElementActivationListener(IEditorPart editorPart, Set<IEditorInput> editorInputs) {
        super(editorPart);
        this.editorInputs = editorInputs;
    }

    @Override
    protected void checkEditorActivated() {
        List<IEditorInput> changed = this.editorInputs.stream().filter(Predicate.not(LibraryElementProvider.INSTANCE::isSynchronized)).sorted(Comparator.comparing(IEditorInput::getToolTipText)).toList();
        if (changed.size() == 1) {
            this.handleEditorInputChanged(changed.getFirst());
        } else if (!changed.isEmpty()) {
            this.handleEditorInputsChanged(changed);
        }
    }

    protected void handleEditorInputsChanged(List<IEditorInput> editorInputs) {
        ListSelectionDialog replaceContentDialog = ListSelectionDialog.of(editorInputs).title(Messages.LibraryElementActivationListener_FileChangedTitle).message(Messages.MultiLibraryElementActivationListener_FilesChangedMessage).okButtonText(Messages.MultiLibraryElementActivationListener_ReplaceContentButton).okButtonTextWhenNoSelection(Messages.LibraryElementActivationListener_IgnoreChangeButton).labelProvider((ILabelProvider)new WorkbenchLabelProvider()).preselect(editorInputs.toArray()).canCancel(false).asSheet(true).create(this.getEditorPart().getSite().getShell());
        if (replaceContentDialog.open() != 0) {
            return;
        }
        MultiStatus status = new MultiStatus(this.getClass(), 0, Messages.MultiLibraryElementActivationListener_SyncErrorMessage);
        List<IEditorInput> selected = Stream.of(replaceContentDialog.getResult()).filter(IEditorInput.class::isInstance).map(IEditorInput.class::cast).toList();
        for (IEditorInput editorInput : selected) {
            try {
                LibraryElementProvider.INSTANCE.synchronize(editorInput, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
        }
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getEditorPart().getSite().getShell(), (String)Messages.LibraryElementActivationListener_SyncErrorTitle, (String)Messages.MultiLibraryElementActivationListener_SyncErrorMessage, (IStatus)status);
        }
    }
}

