/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.widgets;

import java.util.function.Supplier;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.ui.editors.DataTypeTreeSelectionDialog;
import org.eclipse.fordiac.ide.model.ui.nat.TypeNode;
import org.eclipse.fordiac.ide.model.ui.nat.TypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.TypeSelectionProposalProvider;
import org.eclipse.fordiac.ide.ui.widget.nattable.NatTableWidgetFactory;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TypeSelectionButton
extends TextCellEditor {
    private final Supplier<TypeLibrary> supplier;
    private final TypeSelectionTreeContentProvider treeContentProvider;
    private final DelegatingStyledCellLabelProvider.IStyledLabelProvider treeLabelProvider;
    protected Button button;

    public TypeSelectionButton(Supplier<TypeLibrary> supplier, ITypeSelectionContentProvider contentProvider, TypeSelectionTreeContentProvider treeContentProvider) {
        this(supplier, contentProvider, treeContentProvider, null);
    }

    public TypeSelectionButton(Supplier<TypeLibrary> supplier, ITypeSelectionContentProvider contentProvider, TypeSelectionTreeContentProvider treeContentProvider, DelegatingStyledCellLabelProvider.IStyledLabelProvider treeLabelProvider) {
        this.supplier = supplier;
        this.treeContentProvider = treeContentProvider;
        this.treeLabelProvider = treeLabelProvider;
        this.enableContentProposal(supplier, contentProvider);
    }

    protected void enableContentProposal(Supplier<TypeLibrary> supplier, ITypeSelectionContentProvider contentProvider) {
        this.enableContentProposal((IControlContentAdapter)new TextContentAdapter(), new TypeSelectionProposalProvider(supplier, contentProvider), null, NatTableWidgetFactory.getActivationChars());
    }

    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        this.button = new Button(parent, 0x800000);
        this.button.setText("...");
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeTreeSelectionDialog dialog = TypeSelectionButton.this.treeLabelProvider == null ? new DataTypeTreeSelectionDialog(Display.getCurrent().getActiveShell(), TypeSelectionButton.this.treeContentProvider) : new DataTypeTreeSelectionDialog(Display.getCurrent().getActiveShell(), TypeSelectionButton.this.treeContentProvider, TypeSelectionButton.this.treeLabelProvider);
                dialog.setHelpAvailable(false);
                dialog.setInput(TypeSelectionButton.this.supplier.get());
                dialog.setTitle(TypeSelectionButton.this.treeContentProvider.getTitle());
                if (dialog.open() != 0) {
                    if (TypeSelectionButton.this.editMode != EditModeEnum.DIALOG) {
                        TypeSelectionButton.this.close();
                    }
                    return;
                }
                TypeNode selected = (TypeNode)dialog.getFirstResult();
                if (selected != null) {
                    TypeSelectionButton.this.setEditorValue(selected.getFullName());
                    if (TypeSelectionButton.this.editMode == EditModeEnum.INLINE) {
                        TypeSelectionButton.this.commit(SelectionLayer.MoveDirectionEnum.NONE, true);
                    }
                }
            }
        });
        Text text = (Text)super.activateCell(parent, originalCanonicalValue);
        if (this.editMode == EditModeEnum.DIALOG) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
            text.setParent(composite);
            this.button.setParent(composite);
            return parent;
        }
        return parent;
    }

    protected Text createEditorControl(Composite parent, int style) {
        this.focusListener = new ButtonFocusListener();
        return super.createEditorControl(parent, style);
    }

    public Rectangle calculateControlBounds(Rectangle cellBounds) {
        this.button.setBounds(cellBounds.x + cellBounds.width - 25, cellBounds.y, 25, cellBounds.height);
        cellBounds.width -= 25;
        return super.calculateControlBounds(cellBounds);
    }

    public void close() {
        super.close();
        this.button.dispose();
    }

    protected class ButtonFocusListener
    extends AbstractCellEditor.InlineFocusListener {
        protected ButtonFocusListener() {
            super((AbstractCellEditor)TypeSelectionButton.this);
        }

        public void focusLost(FocusEvent e) {
            Point cursorLocation = Display.getDefault().getCursorLocation();
            Point relativeCursorLocation = TypeSelectionButton.this.button.getParent().toControl(cursorLocation);
            if (!TypeSelectionButton.this.button.getBounds().contains(relativeCursorLocation)) {
                super.focusLost(e);
            }
        }
    }
}

