/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import java.text.MessageFormat;
import java.util.Map;
import java.util.SequencedSet;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.data.AnyStringType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.helpers.VarInOutHelper;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerFBNElement;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.impl.NamedElementAnnotations;
import org.eclipse.fordiac.ide.model.validation.LinkConstraints;

public class ConnectionAnnotations {
    public static BlockFBNetworkElement getSourceElement(Connection c) {
        return c.getSource() != null ? c.getSource().getBlockFBNetworkElement() : null;
    }

    public static BlockFBNetworkElement getDestinationElement(Connection c) {
        return c.getDestination() != null ? c.getDestination().getBlockFBNetworkElement() : null;
    }

    public static boolean validateMissingSource(Connection connection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        BlockFBNetworkElement blockFBNetworkElement = connection.getSourceElement();
        if (blockFBNetworkElement instanceof ErrorMarkerFBNElement) {
            ErrorMarkerFBNElement element = (ErrorMarkerFBNElement)blockFBNetworkElement;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 5, MessageFormat.format(Messages.ConnectionAnnotations_SourceElementMissing, element.getName()), FordiacMarkerHelper.getDiagnosticData((EObject)connection, (EStructuralFeature)LibraryElementPackage.Literals.CONNECTION__SOURCE, element.getQualifiedName())));
            }
            return false;
        }
        return true;
    }

    public static boolean validateMissingSourceEndpoint(Connection connection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IInterfaceElement iInterfaceElement = connection.getSource();
        if (iInterfaceElement instanceof ErrorMarkerInterface) {
            ErrorMarkerInterface endpoint = (ErrorMarkerInterface)iInterfaceElement;
            if (!ConnectionAnnotations.isIncomplete(connection.getSourceElement())) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 6, MessageFormat.format(Messages.ConnectionAnnotations_SourceEndpointMissing, endpoint.getName()), FordiacMarkerHelper.getDiagnosticData((EObject)connection, (EStructuralFeature)LibraryElementPackage.Literals.CONNECTION__SOURCE, endpoint.getQualifiedName())));
                }
                return false;
            }
        }
        return true;
    }

    public static boolean validateMissingDestination(Connection connection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        BlockFBNetworkElement blockFBNetworkElement = connection.getDestinationElement();
        if (blockFBNetworkElement instanceof ErrorMarkerFBNElement) {
            ErrorMarkerFBNElement element = (ErrorMarkerFBNElement)blockFBNetworkElement;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 7, MessageFormat.format(Messages.ConnectionAnnotations_DestinationElementMissing, element.getName()), FordiacMarkerHelper.getDiagnosticData((EObject)connection, (EStructuralFeature)LibraryElementPackage.Literals.CONNECTION__DESTINATION, element.getQualifiedName())));
            }
            return false;
        }
        return true;
    }

    public static boolean validateMissingDestinationEndpoint(Connection connection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IInterfaceElement iInterfaceElement = connection.getDestination();
        if (iInterfaceElement instanceof ErrorMarkerInterface) {
            ErrorMarkerInterface endpoint = (ErrorMarkerInterface)iInterfaceElement;
            if (!ConnectionAnnotations.isIncomplete(connection.getDestinationElement())) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 8, MessageFormat.format(Messages.ConnectionAnnotations_DestinationEndpointMissing, endpoint.getName()), FordiacMarkerHelper.getDiagnosticData((EObject)connection, (EStructuralFeature)LibraryElementPackage.Literals.CONNECTION__DESTINATION, endpoint.getQualifiedName())));
                }
                return false;
            }
        }
        return true;
    }

    public static boolean validateDuplicate(Connection connection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (ConnectionAnnotations.isDuplicateConnection(connection)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 9, MessageFormat.format(Messages.ConnectionAnnotations_DuplicateConnection, connection.getSource().getQualifiedName(), connection.getDestination().getQualifiedName()), FordiacMarkerHelper.getDiagnosticData((EObject)connection, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateTypeMismatch(Connection connection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        VarDeclaration destVar;
        VarDeclaration srcVar;
        IInterfaceElement src = connection.getSource();
        IInterfaceElement dest = connection.getDestination();
        if (ConnectionAnnotations.isIncomplete(connection) || connection.isNegated()) {
            return true;
        }
        if (!LinkConstraints.typeCheck(src, dest)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 10, MessageFormat.format(Messages.ConnectionAnnotations_TypeMismatch, src.getQualifiedName(), src.getFullTypeName(), dest.getQualifiedName(), dest.getFullTypeName()), FordiacMarkerHelper.getDiagnosticData((EObject)connection, new String[0])));
            }
            return false;
        }
        if (src instanceof VarDeclaration && (srcVar = (VarDeclaration)src).isInOutVar() && dest instanceof VarDeclaration && !ConnectionAnnotations.typeCheckInOut(srcVar, destVar = (VarDeclaration)dest)) {
            if (diagnostics != null) {
                SequencedSet<VarDeclaration> path = VarInOutHelper.getDefiningVarInOutDeclarationPath(destVar);
                VarDeclaration definingVar = (VarDeclaration)path.removeLast();
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 10, MessageFormat.format(Messages.ConnectionAnnotations_TypeMismatchInOut, definingVar.getQualifiedName(), definingVar.getFullTypeName(), dest.getQualifiedName(), dest.getFullTypeName(), path.isEmpty() ? "" : path.stream().map(v -> MessageFormat.format(Messages.ConnectionAnnotations_TypeMismatchInOutIntermediate, v.getQualifiedName(), v.getFullTypeName())).collect(Collectors.joining(Messages.ConnectionAnnotations_TypeMismatchInOutSeparator, Messages.ConnectionAnnotations_TypeMismatchInOutVia, ""))), FordiacMarkerHelper.getDiagnosticData((EObject)connection, new String[0])));
            }
            return false;
        }
        if (IecTypes.GenericTypes.isAnyType(src.getType()) && IecTypes.GenericTypes.isAnyType(connection.getDestination().getType()) && !ConnectionAnnotations.isContainerPin(src.eContainer().eContainer(), dest.eContainer().eContainer())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 10, MessageFormat.format(Messages.ConnectionAnnotations_GenericEndpoints, src.getQualifiedName(), src.getFullTypeName(), dest.getQualifiedName(), dest.getFullTypeName()), FordiacMarkerHelper.getDiagnosticData((EObject)connection, new String[0])));
            }
            return false;
        }
        return true;
    }

    private static boolean typeCheckInOut(VarDeclaration source, VarDeclaration destination) {
        VarDeclaration destVar;
        VarDeclaration definingVar = VarInOutHelper.getDefiningVarInOutDeclaration(destination);
        if (definingVar == null) {
            return true;
        }
        DataType definingType = LinkConstraints.getFullDataType(definingVar);
        DataType destinationType = LinkConstraints.getFullDataType(destination);
        if (destination instanceof VarDeclaration && (destVar = destination).isInOutVar()) {
            return destinationType.isAssignableFrom(definingType) && (IecTypes.GenericTypes.isAnyType(destinationType) || definingType.isAssignableFrom(destinationType));
        }
        return destinationType.isAssignableFrom(definingType);
    }

    private static boolean isContainerPin(EObject srcParent, EObject destParent) {
        if (srcParent instanceof FBType || destParent instanceof FBType) {
            return true;
        }
        if (srcParent instanceof FBNetworkElement) {
            FBNetworkElement srcElem = (FBNetworkElement)srcParent;
            if (destParent instanceof FBNetworkElement) {
                FBNetworkElement destElem = (FBNetworkElement)destParent;
                if (srcParent instanceof SubApp || srcParent instanceof CFBInstance || destParent instanceof SubApp || destParent instanceof CFBInstance) {
                    return srcElem.getFbNetwork() != destElem.getFbNetwork();
                }
            }
        }
        return false;
    }

    public static boolean validateMappedVarInOutsDoNotCrossResourceBoundaries(Connection connection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Resource destinationResource;
        Resource sourceResource;
        IInterfaceElement source = connection.getSource();
        IInterfaceElement destination = connection.getDestination();
        if (ConnectionAnnotations.isInOutVarOfMappedFB(source) && ConnectionAnnotations.isInOutVarOfMappedFB(destination) && (sourceResource = source.getBlockFBNetworkElement().getResource()) != (destinationResource = destination.getBlockFBNetworkElement().getResource())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 11, Messages.ConnectionValidator_VarInOutConnectionCrossesResourceBoundaries, FordiacMarkerHelper.getDiagnosticData((EObject)connection, new String[0])));
            }
            return false;
        }
        return true;
    }

    private static boolean isInOutVarOfMappedFB(IInterfaceElement ie) {
        VarDeclaration varDecl;
        return ie instanceof VarDeclaration && (varDecl = (VarDeclaration)ie).isInOutVar() && ie.getBlockFBNetworkElement() != null && ie.getBlockFBNetworkElement().isMapped();
    }

    public static boolean validateVarInOutArraySizesAreCompatible(Connection connection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        VarDeclaration definingVarDeclaration;
        VarDeclaration connectionDestinationVar;
        IInterfaceElement iInterfaceElement = connection.getDestination();
        if (iInterfaceElement instanceof VarDeclaration && (connectionDestinationVar = (VarDeclaration)iInterfaceElement).isInOutVar() && (definingVarDeclaration = VarInOutHelper.getDefiningVarInOutDeclaration(connectionDestinationVar)) != null && definingVarDeclaration.isArray() && connectionDestinationVar.isArray() && !definingVarDeclaration.getArraySize().getValue().equals(connectionDestinationVar.getArraySize().getValue()) && !connectionDestinationVar.getArraySize().getValue().contains("*")) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.fordiac.ide.model.libraryElement", 12, MessageFormat.format(Messages.ConnectionValidator_VarInOutArraySizeMismatch, connectionDestinationVar.getFullTypeName(), definingVarDeclaration.getFullTypeName()), FordiacMarkerHelper.getDiagnosticData((EObject)connectionDestinationVar, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateVarInOutStringLengthsMatch(Connection connection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        DataType dataType;
        VarDeclaration definingVarDeclaration;
        VarDeclaration connectionDestinationVar;
        IInterfaceElement iInterfaceElement = connection.getDestination();
        if (iInterfaceElement instanceof VarDeclaration && (connectionDestinationVar = (VarDeclaration)iInterfaceElement).isInOutVar() && (definingVarDeclaration = VarInOutHelper.getDefiningVarInOutDeclaration(connectionDestinationVar)) != null && (dataType = definingVarDeclaration.getType()) instanceof AnyStringType) {
            AnyStringType sourceType = (AnyStringType)dataType;
            DataType dataType2 = connectionDestinationVar.getType();
            if (dataType2 instanceof AnyStringType) {
                AnyStringType destinationType = (AnyStringType)dataType2;
                if (sourceType.getMaxLength() != destinationType.getMaxLength()) {
                    if (diagnostics != null) {
                        diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.fordiac.ide.model.libraryElement", 13, MessageFormat.format(Messages.ConnectionValidator_VarInOutStringSizeMismatch, destinationType.getMaxLength(), sourceType.getMaxLength()), FordiacMarkerHelper.getDiagnosticData((EObject)connectionDestinationVar, new String[0])));
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean validateVarInOutsAreNotConnectedToOuts(Connection connection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        VarDeclaration sourceVar;
        IInterfaceElement iInterfaceElement;
        VarDeclaration destinationVar;
        IInterfaceElement iInterfaceElement2 = connection.getDestination();
        if (iInterfaceElement2 instanceof VarDeclaration && (destinationVar = (VarDeclaration)iInterfaceElement2).isInOutVar() && (iInterfaceElement = connection.getSource()) instanceof VarDeclaration && !(sourceVar = (VarDeclaration)iInterfaceElement).isInOutVar()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 14, Messages.ConnectionValidator_OutputsCannotBeConnectedToVarInOuts, FordiacMarkerHelper.getDiagnosticData((EObject)connection, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateVarInOutConnectionsFormsNoLoop(Connection connection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        VarDeclaration destinationVar;
        IInterfaceElement iInterfaceElement = connection.getDestination();
        if (iInterfaceElement instanceof VarDeclaration && (destinationVar = (VarDeclaration)iInterfaceElement).isInOutVar() && VarInOutHelper.getDefiningVarInOutDeclaration(destinationVar) == null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 15, Messages.ConnectionValidator_VarInOutConnectionsIsALoop, FordiacMarkerHelper.getDiagnosticData((EObject)connection, new String[0])));
            }
            return false;
        }
        return true;
    }

    private static boolean isDuplicateConnection(Connection connection) {
        return connection.getSource() != null && connection.getSource().getOutputConnections().stream().anyMatch(candidate -> candidate != connection && candidate.getDestination() == connection.getDestination());
    }

    static String getConnectionQualifiedName(Connection connection) {
        String sourceName = connection.getSource().getQualifiedName();
        String destinationName = connection.getDestination().getQualifiedName();
        INamedElement namedContainer = NamedElementAnnotations.getNamedContainer(connection);
        if (namedContainer != null) {
            String containerName = namedContainer.getQualifiedName();
            String sourceRelativeName = NamedElementAnnotations.removeQualifiedNamePrefix(sourceName, containerName);
            String destinationRelativeName = NamedElementAnnotations.removeQualifiedNamePrefix(destinationName, containerName);
            return containerName + ".(" + sourceRelativeName + "->" + destinationRelativeName + ")";
        }
        return "(" + sourceName + "->" + destinationName + ")";
    }

    private ConnectionAnnotations() {
        throw new UnsupportedOperationException("Helper class must not be instantiated");
    }

    public static boolean validateNegatedConnection(Connection connection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (connection.isNegated() && !connection.supportsNegated() && !ConnectionAnnotations.isIncomplete(connection)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 16, Messages.ConnectionValidator_NegatedConnectionIsNotValid, FordiacMarkerHelper.getDiagnosticData((EObject)connection, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static void setNegated(Connection connection, boolean negated) {
        if (!negated) {
            connection.deleteAttribute("Negated");
        } else {
            ConnectionAnnotations.setNegated(connection, Boolean.toString(negated));
        }
    }

    private static void setNegated(Connection connection, String negated) {
        connection.setAttribute(InternalAttributeDeclarations.NEGATED, negated, "");
    }

    public static boolean isNegated(Connection connection) {
        String negatedAttribute = connection.getAttributeValue("Negated");
        return "true".equalsIgnoreCase(negatedAttribute);
    }

    public static boolean supportsNegated(Connection connection) {
        return ConnectionAnnotations.isPlainBoolVariable(connection.getSource()) && ConnectionAnnotations.isPlainBoolVariable(connection.getDestination());
    }

    private static boolean isPlainBoolVariable(IInterfaceElement element) {
        VarDeclaration varDeclaration;
        return element instanceof VarDeclaration && !(varDeclaration = (VarDeclaration)element).isInOutVar() && !varDeclaration.isArray() && IecTypes.ElementaryTypes.BOOL.equals(varDeclaration.getType());
    }

    private static boolean isIncomplete(Connection connection) {
        return connection.getSource() == null || connection.getSource() instanceof ErrorMarkerInterface || connection.getDestination() == null || connection.getDestination() instanceof ErrorMarkerInterface;
    }

    private static boolean isIncomplete(BlockFBNetworkElement element) {
        return element instanceof ErrorMarkerFBNElement || element != null && element.getTypeEntry() != null && element.getTypeEntry().hasError();
    }
}

