/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.NamedElementComparator;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.AnyStringType;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.impl.DataTypeEntryImpl;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public final class DataTypeLibrary {
    private static final Pattern STRING_MAX_LENGTH_PATTERN = Pattern.compile("(W?STRING)\\[(\\d+)\\]", 2);
    private final Map<String, DataType> typeMap = new ConcurrentHashMap<String, DataType>();
    private final Map<String, DataTypeEntry> derivedTypes = new ConcurrentHashMap<String, DataTypeEntry>();

    public DataTypeLibrary() {
        this.initElementaryTypes();
        this.initGenericTypes();
    }

    public boolean addTypeEntry(DataTypeEntry entry) {
        boolean added;
        String uppercaseName = entry.getFullTypeName().toUpperCase();
        DataTypeEntry oldEntry = this.removeErrorTypeEntry(uppercaseName);
        boolean bl = added = this.derivedTypes.putIfAbsent(uppercaseName, entry) == null;
        if (oldEntry != null) {
            oldEntry.setTypeLibrary(null);
        }
        return added;
    }

    public void removeTypeEntry(DataTypeEntry entry) {
        this.derivedTypes.remove(entry.getFullTypeName().toUpperCase(), entry);
    }

    private DataTypeEntry removeErrorTypeEntry(String uppercaseName) {
        DataTypeEntry oldEntry = this.derivedTypes.get(uppercaseName);
        while (oldEntry != null && oldEntry.getFile() == null) {
            if (this.derivedTypes.remove(uppercaseName, oldEntry)) {
                return oldEntry;
            }
            oldEntry = this.derivedTypes.get(uppercaseName);
        }
        return null;
    }

    private void addToTypeMap(DataType type) {
        this.typeMap.putIfAbsent(type.getName().toUpperCase(), type);
    }

    private void initElementaryTypes() {
        IecTypes.ElementaryTypes.getAllElementaryType().forEach(this::addToTypeMap);
    }

    private void initGenericTypes() {
        IecTypes.GenericTypes.getAllGenericTypes().forEach(this::addToTypeMap);
    }

    public Stream<DataTypeEntry> getDerivedDataTypes() {
        return this.derivedTypes.values().stream().filter(Predicate.not(TypeEntry::hasError));
    }

    public List<DataType> getDataTypes() {
        return Stream.concat(this.typeMap.values().stream(), this.derivedTypes.values().stream().map(DataTypeEntry::getType).filter(Objects::nonNull)).toList();
    }

    public static List<DataType> getNonUserDefinedDataTypes() {
        return IecTypes.ElementaryTypes.getAllElementaryType();
    }

    public Stream<DataType> getDataTypesSorted() {
        return this.getDataTypes().stream().sorted(NamedElementComparator.INSTANCE);
    }

    public DataType getType(String name) {
        if (name == null) {
            return IecTypes.GenericTypes.ANY;
        }
        String uppercaseName = name.toUpperCase();
        DataType type = this.typeMap.get(uppercaseName);
        if (type != null) {
            return type;
        }
        type = this.getDerivedType(uppercaseName);
        if (type != null) {
            return type;
        }
        type = this.createParametricType(name);
        if (type != null) {
            return type;
        }
        return this.createErrorMarkerType(name, MessageFormat.format(Messages.DataTypeLibrary_MissingDatatype, name));
    }

    public DataType getTypeIfExists(String name) {
        String uppercaseName = name.toUpperCase();
        DataType dataType = this.typeMap.get(uppercaseName);
        if (dataType != null) {
            return dataType;
        }
        return this.getDerivedType(uppercaseName);
    }

    public List<StructuredType> getStructuredTypes() {
        return Stream.concat(Stream.of(IecTypes.GenericTypes.ANY_STRUCT), this.derivedTypes.values().stream().map(TypeEntry::getType).filter(StructuredType.class::isInstance).map(StructuredType.class::cast)).toList();
    }

    public List<StructuredType> getStructuredTypesSorted() {
        return this.getStructuredTypes().stream().sorted(NamedElementComparator.INSTANCE).toList();
    }

    private DataType getDerivedType(String uppercaseName) {
        DataTypeEntry entry = this.derivedTypes.get(uppercaseName);
        if (entry != null) {
            return entry.getType();
        }
        return null;
    }

    public DataTypeEntry getDerivedTypeEntry(String name) {
        return this.derivedTypes.get(name.toUpperCase());
    }

    private DataType createParametricType(String typeName) {
        Matcher matcher = STRING_MAX_LENGTH_PATTERN.matcher(typeName);
        if (matcher.matches()) {
            try {
                String plainTypeName = matcher.group(1);
                String maxLengthString = matcher.group(2);
                DataType plainType = this.typeMap.get(plainTypeName.toUpperCase());
                if (plainType instanceof AnyStringType) {
                    int maxLength = Integer.parseUnsignedInt(maxLengthString);
                    return this.typeMap.computeIfAbsent(typeName.toUpperCase(), name -> {
                        AnyStringType type = (AnyStringType)DataFactory.eINSTANCE.create(plainType.eClass());
                        type.setName((String)name);
                        type.setMaxLength(maxLength);
                        DataTypeLibrary.encloseInResource(type);
                        return type;
                    });
                }
            }
            catch (NumberFormatException e) {
                return this.createErrorMarkerType(typeName, MessageFormat.format(Messages.DataTypeLibrary_InvalidMaxLengthInStringType, typeName));
            }
        }
        return null;
    }

    private AnyDerivedType createErrorMarkerType(String typeName, String message) {
        return this.derivedTypes.computeIfAbsent(typeName.toUpperCase(), name -> {
            FordiacLogHelper.logInfo((String)message);
            DataTypeEntryImpl entry = new DataTypeEntryImpl();
            AnyDerivedType type = entry.getType();
            PackageNameHelper.setFullTypeName(type, typeName);
            entry.setType(type);
            return entry;
        }).getType();
    }

    private static void encloseInResource(DataType type) {
        new ResourceImpl(URI.createFileURI((String)(type.getName() + ".datalib.dtp"))).getContents().add((Object)type);
    }

    public StructuredType getStructuredType(String name) {
        DataType derivedType = this.getDerivedType(name.toUpperCase());
        if (derivedType instanceof StructuredType) {
            StructuredType structuredType = (StructuredType)derivedType;
            return structuredType;
        }
        return IecTypes.GenericTypes.ANY_STRUCT;
    }

    void clear() {
        this.derivedTypes.clear();
    }
}

