/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.dataexport.AdapterExporter;
import org.eclipse.fordiac.ide.model.dataimport.ADPImporter;
import org.eclipse.fordiac.ide.model.dataimport.BlockTypeImporter;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorAdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.impl.AbstractInterfaceTypeEntryImpl;

public class AdapterTypeEntryImpl
extends AbstractInterfaceTypeEntryImpl<AdapterType>
implements AdapterTypeEntry {
    public AdapterTypeEntryImpl() {
        super(AdapterType.class);
    }

    @Override
    protected BlockTypeImporter getImporter() {
        return new ADPImporter(this.getFile());
    }

    @Override
    protected ErrorAdapterType createErrorLibraryElement() {
        ErrorAdapterType type = LibraryElementFactory.eINSTANCE.createErrorAdapterType();
        type.setInterfaceList(LibraryElementFactory.eINSTANCE.createInterfaceList());
        return type;
    }

    @Override
    protected AbstractTypeExporter getTypeExporter(AdapterType type) {
        return new AdapterExporter(type);
    }

    @Override
    public EClass getTypeEClass() {
        return LibraryElementPackage.Literals.ADAPTER_TYPE;
    }

    @Override
    public String getFileExtension() {
        return "ADP";
    }

    @Override
    protected synchronized NotificationChain basicSetType(LibraryElement type, NotificationChain notifications) {
        if (type instanceof AdapterType) {
            AdapterType adpType = (AdapterType)type;
            adpType.setPlugType(AdapterTypeEntryImpl.createPlugType(adpType));
        }
        return super.basicSetType(type, notifications);
    }

    public static AdapterType createPlugType(AdapterType adapterType) {
        AdapterType temp = (AdapterType)EcoreUtil.copy((EObject)adapterType);
        ArrayList<Event> inputEvents = new ArrayList<Event>((Collection<Event>)temp.getInterfaceList().getEventOutputs());
        ArrayList<VarDeclaration> inputVars = new ArrayList<VarDeclaration>((Collection<VarDeclaration>)temp.getInterfaceList().getOutputVars());
        Stream.concat(inputEvents.stream(), inputVars.stream()).forEach(element -> element.setIsInput(true));
        ArrayList<Event> outputEvents = new ArrayList<Event>((Collection<Event>)temp.getInterfaceList().getEventInputs());
        ArrayList<VarDeclaration> outputVars = new ArrayList<VarDeclaration>((Collection<VarDeclaration>)temp.getInterfaceList().getInputVars());
        Stream.concat(outputEvents.stream(), outputVars.stream()).forEach(event -> event.setIsInput(false));
        temp.getInterfaceList().getEventInputs().clear();
        temp.getInterfaceList().getEventOutputs().clear();
        temp.getInterfaceList().getInputVars().clear();
        temp.getInterfaceList().getOutputVars().clear();
        temp.getInterfaceList().getEventInputs().addAll(inputEvents);
        temp.getInterfaceList().getEventOutputs().addAll(outputEvents);
        temp.getInterfaceList().getInputVars().addAll(inputVars);
        temp.getInterfaceList().getOutputVars().addAll(outputVars);
        AdapterTypeEntryImpl.processVarInOutInWiths(temp.getInterfaceList().getEventInputs());
        AdapterTypeEntryImpl.processVarInOutInWiths(temp.getInterfaceList().getEventOutputs());
        return temp;
    }

    private static void processVarInOutInWiths(EList<Event> events) {
        events.stream().flatMap(ev -> ev.getWith().stream()).filter(w -> w.getVariables().isInOutVar()).forEach(w -> w.setVariables(w.getVariables().getInOutVarOpposite()));
    }
}

