/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng;

import java.nio.file.Path;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.ExportTemplate;
import org.eclipse.fordiac.ide.export.forte_ng.util.ForteNgExportOptions;
import org.eclipse.fordiac.ide.export.forte_ng.util.ForteNgExportUtil;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class ForteNgExportTemplate
extends ExportTemplate {
    public static final String HEADER_TEXT = "This file was generated using the 4DIAC FORTE Export Filter " + ForteNgExportTemplate.getExporterVersion() + "!";

    protected ForteNgExportTemplate(String name, Path prefix) {
        super(name, prefix);
    }

    protected CharSequence generateDependencyIncludes(Iterable<? extends INamedElement> dependencies) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> ForteNgExportUtil.generateDefiningIncludes((EObject)it);
        List _sort = IterableExtensions.sort((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.flatMap(dependencies, (Functions.Function1)_function)));
        for (String include : _sort) {
            CharSequence _generateDependencyInclude = this.generateDependencyInclude(include);
            _builder.append((Object)_generateDependencyInclude);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateDependencyInclude(String path) {
        StringConcatenation _xifexpression = null;
        boolean _useSystemIncludes = ForteNgExportOptions.useSystemIncludes();
        if (_useSystemIncludes) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("#include <");
            _builder.append(path);
            _builder.append(">");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("#include \"");
            _builder_1.append(path);
            _builder_1.append("\"");
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    public String getFileBasename() {
        return this.getName().replaceAll("\\.[^.]+$", "");
    }

    public static String getExporterVersion() {
        Bundle bundle = FrameworkUtil.getBundle(ForteNgExportTemplate.class);
        if (bundle != null) {
            return bundle.getVersion().toString();
        }
        return "3.0.x";
    }
}

