/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search;

import java.util.Arrays;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.TextAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.TextMethod;
import org.eclipse.fordiac.ide.model.search.IModelSearchContentProvider;
import org.eclipse.fordiac.ide.model.search.ModelSearchResult;
import org.eclipse.fordiac.ide.model.search.ModelSearchResultPage;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class ModelSearchTableContentProvider
implements IStructuredContentProvider,
IModelSearchContentProvider {
    private final ModelSearchResultPage resultPage;
    private ModelSearchResult result;
    private static final Object[] EMPTY_ARR = new Object[0];

    public ModelSearchTableContentProvider(ModelSearchResultPage page) {
        this.resultPage = page;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ModelSearchResult) {
            ModelSearchResult modelResult;
            this.result = modelResult = (ModelSearchResult)((Object)inputElement);
            return this.result.getResults().stream().flatMap(eObj -> {
                URI uri;
                if ((eObj instanceof TextAlgorithm || eObj instanceof TextMethod || eObj instanceof FunctionFBType) && this.result.hasFordiacMatch(uri = EcoreUtil.getURI((EObject)eObj))) {
                    return Arrays.stream(this.result.getFordiacMatches(uri));
                }
                return Stream.of(eObj);
            }).toArray();
        }
        return EMPTY_ARR;
    }

    private TableViewer getViewer() {
        return (TableViewer)this.resultPage.getViewer();
    }

    @Override
    public void clear() {
        this.getViewer().setInput(null);
        this.getViewer().refresh();
    }

    @Override
    public void elementsChanged(Object[] updatedElements) {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.result = (ModelSearchResult)((Object)newInput);
    }

    ModelSearchResult getSearchResult() {
        return this.result;
    }
}

