/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.util.Objects;
import org.eclipse.fordiac.ide.model.data.WstringType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyCharsValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyStringValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyWCharsValue;
import org.eclipse.fordiac.ide.model.eval.value.WCharValue;
import org.eclipse.fordiac.ide.model.value.WStringValueConverter;

public final class WStringValue
implements AnyStringValue,
AnyWCharsValue {
    public static final WStringValue DEFAULT = new WStringValue("");
    private final String value;

    private WStringValue(String value) {
        this.value = value;
    }

    public static WStringValue toWStringValue(String value) {
        return WStringValue.toWStringValue(value, 65534);
    }

    public static WStringValue toWStringValue(String value, int maxLength) {
        return new WStringValue(WStringValue.truncate(value, maxLength));
    }

    public static WStringValue toWStringValue(AnyCharsValue value) {
        return WStringValue.toWStringValue(value, 65534);
    }

    public static WStringValue toWStringValue(AnyCharsValue value, int maxLength) {
        return WStringValue.toWStringValue(value.stringValue(), maxLength);
    }

    @Override
    public WCharValue charAt(int index) {
        return WCharValue.toWCharValue(index > 0 && index <= this.value.length() ? this.value.charAt(index - 1) : (char)'\u0000');
    }

    public WStringValue withCharAt(int index, WCharValue c) {
        if (index <= 0) {
            throw new StringIndexOutOfBoundsException(index);
        }
        StringBuilder newValue = new StringBuilder(this.value);
        if (newValue.length() < index) {
            newValue.setLength(index);
        }
        newValue.setCharAt(index - 1, c.charValue());
        return new WStringValue(newValue.toString());
    }

    public WstringType getType() {
        return IecTypes.ElementaryTypes.WSTRING;
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charValue() {
        return !this.value.isEmpty() ? this.value.charAt(0) : (char)'\u0000';
    }

    @Override
    public String stringValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WStringValue other = (WStringValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return WStringValueConverter.INSTANCE.toString(this.stringValue());
    }

    private static String truncate(String value, int maxLength) {
        if (value.length() > maxLength) {
            return value.substring(0, maxLength);
        }
        return value;
    }
}

