/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.issuereport;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.fordiac.ide.Messages;
import org.eclipse.fordiac.ide.issuereport.PreferenceConstants;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GitIssueReportingPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button noReportButton;
    private Button promptReportButton;
    private Button autoReportButton;
    private Group group;
    private Button gitHubManualButton;
    private Button gitLabButton;
    private Text gitLabURLText;
    private Text gitLabProjectPathText;
    private Text gitLabTokenText;
    private Button gitHubButton;
    private Text gitHubURLText;
    private Text gitHubProjectPathText;
    private Text gitHubTokenText;
    private PreferenceConstants.ReportMode reportMode;
    private PreferenceConstants.ReportDestination reportDestination;

    public GitIssueReportingPage() {
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.fordiac.ide.issuereport"));
    }

    public void init(IWorkbench workbench) {
        this.reportMode = PreferenceConstants.getReportMode();
        this.reportDestination = PreferenceConstants.getReportDestination();
        this.getPreferenceStore().setDefault("bugReportingGitHubURL", "https://api.github.com/");
    }

    protected void performDefaults() {
        this.noReportButton.setSelection(false);
        this.promptReportButton.setSelection(true);
        this.autoReportButton.setSelection(false);
        this.selectReportMode(PreferenceConstants.ReportMode.PROMPT_REPORT);
        this.reportDestination = PreferenceConstants.ReportDestination.GITHUB_MANUAL;
        this.gitHubManualButton.setSelection(true);
        this.gitLabButton.setSelection(false);
        this.gitHubButton.setSelection(false);
        this.selectReportDest(PreferenceConstants.ReportDestination.GITHUB_MANUAL);
        IPreferenceStore store = this.getPreferenceStore();
        this.gitLabURLText.setText(store.getDefaultString("bugReportingGitLabURL"));
        this.gitLabProjectPathText.setText(store.getDefaultString("bugReportingGitLabProjectPath"));
        this.gitLabTokenText.setText(store.getDefaultString("bugReportingGitLabToken"));
        this.gitHubURLText.setText(store.getDefaultString("bugReportingGitHubURL"));
        this.gitHubProjectPathText.setText(store.getDefaultString("bugReportingGitHubProjectPath"));
        this.gitHubTokenText.setText(store.getDefaultString("bugReportingGitHubToken"));
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("bugReportingMode", this.reportMode.toString());
        store.setValue("bugReportingDestination", this.reportDestination.toString());
        store.setValue("bugReportingGitLabURL", this.gitLabURLText.getText());
        store.setValue("bugReportingGitLabProjectPath", this.gitLabProjectPathText.getText());
        store.setValue("bugReportingGitLabToken", this.gitLabTokenText.getText());
        store.setValue("bugReportingGitHubURL", this.gitHubURLText.getText());
        store.setValue("bugReportingGitHubProjectPath", this.gitHubProjectPathText.getText());
        store.setValue("bugReportingGitHubToken", this.gitHubTokenText.getText());
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        Composite composite = GitIssueReportingPage.createComposite(parent);
        this.createReportModeGroup(composite);
        this.createReportDestinationGroup(composite);
        return composite;
    }

    private void createReportModeGroup(Composite composite) {
        Group buttonComposite = new Group(composite, 16384);
        GridLayout layout = new GridLayout();
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        buttonComposite.setLayoutData((Object)data);
        buttonComposite.setText(Messages.IssueReporting_ModeGroupLabel);
        this.noReportButton = GitIssueReportingPage.createRadioButton((Composite)buttonComposite, Messages.IssueReporting_NoReport);
        this.noReportButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.selectReportMode(PreferenceConstants.ReportMode.NO_REPORT)));
        this.noReportButton.setSelection(this.reportMode == PreferenceConstants.ReportMode.NO_REPORT);
        this.promptReportButton = GitIssueReportingPage.createRadioButton((Composite)buttonComposite, Messages.IssueReporting_PromptReport);
        this.promptReportButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.selectReportMode(PreferenceConstants.ReportMode.PROMPT_REPORT)));
        this.promptReportButton.setSelection(this.reportMode == PreferenceConstants.ReportMode.PROMPT_REPORT);
        this.autoReportButton = GitIssueReportingPage.createRadioButton((Composite)buttonComposite, Messages.IssueReporting_AutoReport);
        this.autoReportButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.selectReportMode(PreferenceConstants.ReportMode.AUTO_REPORT)));
        this.autoReportButton.setSelection(this.reportMode == PreferenceConstants.ReportMode.AUTO_REPORT);
    }

    private void createReportDestinationGroup(Composite composite) {
        this.group = new Group(composite, 16384);
        GridLayout layout = new GridLayout(2, false);
        this.group.setLayout((Layout)layout);
        GridData data = new GridData(768);
        this.group.setLayoutData((Object)data);
        this.group.setText(Messages.IssueReporting_DestinationGroupLabel);
        this.group.setVisible(this.reportMode != PreferenceConstants.ReportMode.NO_REPORT);
        this.gitHubManualButton = this.createDestinationButton((Composite)this.group, Messages.IssueReporting_GitHub_Manual, PreferenceConstants.ReportDestination.GITHUB_MANUAL);
        boolean isGitHub = this.reportDestination == PreferenceConstants.ReportDestination.GITHUB;
        this.gitHubButton = this.createDestinationButton((Composite)this.group, Messages.IssueReporting_GitHub, PreferenceConstants.ReportDestination.GITHUB);
        GitIssueReportingPage.createFieldLabel((Composite)this.group, Messages.IssueReporting_URLInput);
        this.gitHubURLText = GitIssueReportingPage.createFieldInput((Composite)this.group, isGitHub, PreferenceConstants.getReportGitHubURL());
        GitIssueReportingPage.createFieldLabel((Composite)this.group, Messages.IssueReporting_ProjectPathInput);
        this.gitHubProjectPathText = GitIssueReportingPage.createFieldInput((Composite)this.group, isGitHub, PreferenceConstants.getReportGitHubProjectPath());
        this.gitHubProjectPathText.setToolTipText(Messages.IssueReporting_ProjectPathToolTip);
        GitIssueReportingPage.createFieldLabel((Composite)this.group, Messages.IssueReporting_TokenInput);
        this.gitHubTokenText = GitIssueReportingPage.createFieldInput((Composite)this.group, isGitHub, PreferenceConstants.getReportGitHubToken());
        this.gitHubTokenText.setEchoChar('*');
        boolean isGitLab = this.reportDestination == PreferenceConstants.ReportDestination.GITLAB;
        this.gitLabButton = this.createDestinationButton((Composite)this.group, Messages.IssueReporting_GitLab, PreferenceConstants.ReportDestination.GITLAB);
        GitIssueReportingPage.createFieldLabel((Composite)this.group, Messages.IssueReporting_URLInput);
        this.gitLabURLText = GitIssueReportingPage.createFieldInput((Composite)this.group, isGitLab, PreferenceConstants.getReportGitLabURL());
        GitIssueReportingPage.createFieldLabel((Composite)this.group, Messages.IssueReporting_ProjectPathInput);
        this.gitLabProjectPathText = GitIssueReportingPage.createFieldInput((Composite)this.group, isGitLab, PreferenceConstants.getReportGitLabProjectPath());
        this.gitLabProjectPathText.setToolTipText(Messages.IssueReporting_ProjectPathToolTip);
        GitIssueReportingPage.createFieldLabel((Composite)this.group, Messages.IssueReporting_TokenInput);
        this.gitLabTokenText = GitIssueReportingPage.createFieldInput((Composite)this.group, isGitLab, PreferenceConstants.getReportGitLabToken());
        this.gitLabTokenText.setEchoChar('*');
    }

    private static Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        return composite;
    }

    private Button createDestinationButton(Composite parent, String label, PreferenceConstants.ReportDestination reportDest) {
        Button button = GitIssueReportingPage.createRadioButton(parent, label);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.selectReportDest(reportDest)));
        button.setSelection(this.reportDestination == reportDest);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        button.setLayoutData((Object)data);
        return button;
    }

    private static Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        return button;
    }

    private static void createFieldLabel(Composite composite, String text) {
        Label label = new Label(composite, 0);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalIndent = LayoutConstants.getIndent();
        label.setLayoutData((Object)data);
    }

    private static Text createFieldInput(Composite composite, boolean enabled, String initialText) {
        Text text = new Text(composite, 2052);
        text.setEnabled(enabled);
        text.setLayoutData((Object)new GridData(768));
        if (initialText != null) {
            text.setText(initialText);
        }
        return text;
    }

    private void selectReportMode(PreferenceConstants.ReportMode mode) {
        this.reportMode = mode;
        this.group.setVisible(mode != PreferenceConstants.ReportMode.NO_REPORT);
    }

    private void selectReportDest(PreferenceConstants.ReportDestination dest) {
        this.reportDestination = dest;
        boolean isGitLab = dest == PreferenceConstants.ReportDestination.GITLAB;
        this.gitLabURLText.setEnabled(isGitLab);
        this.gitLabProjectPathText.setEnabled(isGitLab);
        this.gitLabTokenText.setEnabled(isGitLab);
        boolean isGitHub = dest == PreferenceConstants.ReportDestination.GITHUB;
        this.gitHubURLText.setEnabled(isGitHub);
        this.gitHubProjectPathText.setEnabled(isGitHub);
        this.gitHubTokenText.setEnabled(isGitHub);
    }
}

