/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import java.util.List;
import java.util.Objects;
import org.eclipse.fordiac.ide.gef.nat.VariableTableColumn;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.ui.widget.nattable.AbstractColumnAccessor;

public class VariableColumnAccessor
extends AbstractColumnAccessor<Variable<?>, VariableTableColumn> {
    private static final String NULL_DEFAULT = "";

    public VariableColumnAccessor() {
        this(VariableTableColumn.DEFAULT_COLUMNS);
    }

    public VariableColumnAccessor(List<VariableTableColumn> columns) {
        super(columns);
    }

    public Object getDataValue(Variable<?> rowObject, VariableTableColumn column) {
        return switch (column) {
            case VariableTableColumn.NAME -> rowObject.getName();
            case VariableTableColumn.TYPE -> {
                LibraryElement var4_3 = rowObject.getType();
                if (var4_3 instanceof LibraryElement) {
                    LibraryElement libraryElement = var4_3;
                    yield PackageNameHelper.getFullTypeName((LibraryElement)libraryElement);
                }
                yield rowObject.getType().getName();
            }
            case VariableTableColumn.VALUE -> rowObject.toString();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)column));
        };
    }

    public void setDataValue(Variable<?> rowObject, VariableTableColumn column, Object newValue) {
        switch (column) {
            case VALUE: {
                rowObject.setValue(Objects.toString(newValue, NULL_DEFAULT));
                break;
            }
            case NAME: 
            case TYPE: {
                throw new UnsupportedOperationException("Cannot set value for column: " + column.getDisplayName());
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)column));
            }
        }
    }
}

