/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p2layers;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;

public final class MinWidthLayerer
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final Range<Integer> UPPERBOUND_ON_WIDTH_RANGE = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4));
    private static final Range<Integer> COMPENSATOR_RANGE = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2));
    private double dummySize;
    private double minimumNodeSize;
    private double[] normSize;
    private double avgSize;
    private SelfLoopPredicate isSelfLoopTest = new SelfLoopPredicate();
    private int[] inDegree;
    private int[] outDegree;

    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P1_CYCLE_BREAKING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.EDGE_AND_LAYER_CONSTRAINT_EDGE_REVERSER).addBefore((Enum)LayeredPhases.P2_LAYERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LAYER_CONSTRAINT_PREPROCESSOR).addBefore((Enum)LayeredPhases.P3_NODE_ORDERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LAYER_CONSTRAINT_POSTPROCESSOR);
    }

    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("MinWidth layering", 1.0f);
        List<Layer> layers = layeredGraph.getLayers();
        List<LNode> notInserted = layeredGraph.getLayerlessNodes();
        int upperBoundOnWidth = (Integer)layeredGraph.getProperty(LayeredOptions.LAYERING_MIN_WIDTH_UPPER_BOUND_ON_WIDTH);
        int compensator = (Integer)layeredGraph.getProperty(LayeredOptions.LAYERING_MIN_WIDTH_UPPER_LAYER_ESTIMATION_SCALING_FACTOR);
        this.dummySize = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_EDGE);
        this.minimumNodeSize = Double.POSITIVE_INFINITY;
        for (LNode node : notInserted) {
            if (node.getType() != LNode.NodeType.NORMAL) continue;
            double size = node.getSize().y;
            this.minimumNodeSize = Math.min(this.minimumNodeSize, size);
        }
        this.minimumNodeSize = Math.max(1.0, this.minimumNodeSize);
        int numOfNodes = notInserted.size();
        this.inDegree = new int[numOfNodes];
        this.outDegree = new int[numOfNodes];
        this.normSize = new double[numOfNodes];
        int i = 0;
        this.avgSize = 0.0;
        for (LNode node : notInserted) {
            node.id = i++;
            this.inDegree[node.id] = this.countEdgesExceptSelfLoops(node.getIncomingEdges());
            this.outDegree[node.id] = this.countEdgesExceptSelfLoops(node.getOutgoingEdges());
            this.normSize[node.id] = node.getSize().y / this.minimumNodeSize;
            this.avgSize += this.normSize[node.id];
        }
        this.dummySize /= this.minimumNodeSize;
        this.avgSize /= (double)numOfNodes;
        List<Set<LNode>> nodeSuccessors = this.precalcSuccessors(notInserted);
        notInserted.sort(Collections.reverseOrder(new MinOutgoingEdgesComparator()));
        double minWidth = Double.POSITIVE_INFINITY;
        int minNumOfLayers = Integer.MAX_VALUE;
        List candidateLayering = null;
        int ubwStart = upperBoundOnWidth;
        int ubwEnd = upperBoundOnWidth;
        int cStart = compensator;
        int cEnd = compensator;
        if (upperBoundOnWidth < 0) {
            ubwStart = (Integer)UPPERBOUND_ON_WIDTH_RANGE.lowerEndpoint();
            ubwEnd = (Integer)UPPERBOUND_ON_WIDTH_RANGE.upperEndpoint();
        }
        if (compensator < 0) {
            cStart = (Integer)COMPENSATOR_RANGE.lowerEndpoint();
            cEnd = (Integer)COMPENSATOR_RANGE.upperEndpoint();
        }
        int ubw = ubwStart;
        while (ubw <= ubwEnd) {
            int c = cStart;
            while (c <= cEnd) {
                Pair<Double, List<List<LNode>>> result = this.computeMinWidthLayering(ubw, c, notInserted, nodeSuccessors);
                double newWidth = (Double)result.getFirst();
                List layering = (List)result.getSecond();
                int newNumOfLayers = layering.size();
                if (newWidth < minWidth || newWidth == minWidth && newNumOfLayers < minNumOfLayers) {
                    minWidth = newWidth;
                    minNumOfLayers = newNumOfLayers;
                    candidateLayering = layering;
                }
                ++c;
            }
            ++ubw;
        }
        for (List layerList : candidateLayering) {
            Layer currentLayer = new Layer(layeredGraph);
            for (LNode node : layerList) {
                node.setLayer(currentLayer);
            }
            layers.add(currentLayer);
        }
        Collections.reverse(layers);
        notInserted.clear();
        progressMonitor.done();
    }

    private List<Set<LNode>> precalcSuccessors(Collection<LNode> nodes) {
        ArrayList successors = Lists.newArrayListWithCapacity((int)nodes.size());
        for (LNode node : nodes) {
            HashSet outNodes = Sets.newHashSet();
            Iterable<LEdge> outEdges = node.getOutgoingEdges();
            for (LEdge edge : outEdges) {
                if (this.isSelfLoopTest.apply(edge)) continue;
                outNodes.add(edge.getTarget().getNode());
            }
            successors.add(outNodes);
        }
        return successors;
    }

    private Pair<Double, List<List<LNode>>> computeMinWidthLayering(int upperBoundOnWidth, int compensator, Iterable<LNode> nodes, List<Set<LNode>> nodeSuccessors) {
        ArrayList layers = Lists.newArrayList();
        LinkedHashSet unplacedNodes = Sets.newLinkedHashSet(nodes);
        double ubwConsiderSize = (double)upperBoundOnWidth * this.avgSize;
        int inDeg = 0;
        int outDeg = 0;
        HashSet alreadyPlacedInCurrentLayer = Sets.newHashSet();
        HashSet alreadyPlacedInOtherLayers = Sets.newHashSet();
        ArrayList currentLayer = Lists.newArrayList();
        double widthCurrent = 0.0;
        double widthUp = 0.0;
        double maxWidth = 0.0;
        double realWidth = 0.0;
        double currentSpanningEdges = 0.0;
        double goingOutFromThisLayer = 0.0;
        while (!unplacedNodes.isEmpty()) {
            LNode currentNode = this.selectNode(unplacedNodes, nodeSuccessors, alreadyPlacedInOtherLayers);
            if (currentNode != null) {
                unplacedNodes.remove((Object)currentNode);
                currentLayer.add(currentNode);
                alreadyPlacedInCurrentLayer.add(currentNode);
                outDeg = this.outDegree[currentNode.id];
                widthCurrent += this.normSize[currentNode.id] - (double)outDeg * this.dummySize;
                inDeg = this.inDegree[currentNode.id];
                widthUp += (double)inDeg * this.dummySize;
                goingOutFromThisLayer += (double)outDeg * this.dummySize;
                realWidth += this.normSize[currentNode.id];
            }
            if (!(currentNode == null || unplacedNodes.isEmpty() || widthCurrent >= ubwConsiderSize && this.normSize[currentNode.id] > (double)outDeg * this.dummySize) && !(widthUp >= (double)compensator * ubwConsiderSize)) continue;
            layers.add(currentLayer);
            currentLayer = Lists.newArrayList();
            alreadyPlacedInOtherLayers.addAll(alreadyPlacedInCurrentLayer);
            alreadyPlacedInCurrentLayer.clear();
            maxWidth = Math.max(maxWidth, (currentSpanningEdges -= goingOutFromThisLayer) * this.dummySize + realWidth);
            currentSpanningEdges += widthUp;
            widthCurrent = widthUp;
            widthUp = 0.0;
            goingOutFromThisLayer = 0.0;
            realWidth = 0.0;
        }
        return Pair.of((Object)maxWidth, (Object)layers);
    }

    private LNode selectNode(Set<LNode> nodes, List<Set<LNode>> successors, Set<LNode> targets) {
        for (LNode node : nodes) {
            if (!targets.containsAll((Collection)successors.get(node.id))) continue;
            return node;
        }
        return null;
    }

    private int countEdgesExceptSelfLoops(Iterable<LEdge> edges) {
        int i = 0;
        for (LEdge edge : edges) {
            if (this.isSelfLoopTest.apply(edge)) continue;
            ++i;
        }
        return i;
    }

    private class MinOutgoingEdgesComparator
    implements Comparator<LNode> {
        private MinOutgoingEdgesComparator() {
        }

        @Override
        public int compare(LNode o1, LNode o2) {
            int outs1 = MinWidthLayerer.this.outDegree[o1.id];
            int outs2 = MinWidthLayerer.this.outDegree[o2.id];
            if (outs1 < outs2) {
                return -1;
            }
            if (outs1 == outs2) {
                return 0;
            }
            return 1;
        }
    }

    private class SelfLoopPredicate
    implements Predicate<LEdge> {
        private SelfLoopPredicate() {
        }

        public boolean apply(LEdge input) {
            return ((Object)((Object)input.getSource().getNode())).equals((Object)input.getTarget().getNode());
        }
    }
}

