/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.widgets.Display;

public enum CoordinateConverter {
    INSTANCE;

    private final double transformationScale;
    private final double lineHeight;
    private final double averageCharacterWidth;
    private static final double DEFAULT_LINE_HEIGHT = 19.0;
    private static final double DEFAULT_CHARACTER_WIDTH = 8.0;

    private CoordinateConverter() {
        LineHeightRunnable lineHeightCalc = new LineHeightRunnable();
        Display display = Display.getDefault();
        if (display != null) {
            display.syncExec((Runnable)lineHeightCalc);
            this.lineHeight = lineHeightCalc.getLineHeight();
            this.averageCharacterWidth = lineHeightCalc.getAverageCharacterWidth();
        } else {
            this.lineHeight = 19.0;
            this.averageCharacterWidth = 8.0;
        }
        this.transformationScale = this.lineHeight / 100.0;
    }

    public int iec61499ToScreen(double value) {
        return (int)Math.round(value * this.transformationScale);
    }

    public double screenToIEC61499(int value) {
        return (double)value / this.transformationScale;
    }

    public double getLineHeight() {
        return this.lineHeight;
    }

    public double getAverageCharacterWidth() {
        return this.averageCharacterWidth;
    }

    public Position createPosFromScreenCoordinates(int x, int y) {
        Position pos = LibraryElementFactory.eINSTANCE.createPosition();
        pos.setX(this.screenToIEC61499(x));
        pos.setY(this.screenToIEC61499(y));
        return pos;
    }

    private static class LineHeightRunnable
    implements Runnable {
        private double lineHeight;
        private double averageCharacterWidth;

        private LineHeightRunnable() {
        }

        public double getLineHeight() {
            return this.lineHeight;
        }

        public double getAverageCharacterWidth() {
            return this.averageCharacterWidth;
        }

        @Override
        public void run() {
            Font diagramFont = JFaceResources.getFont((String)"org.eclipse.fordiac.ide.preferences.diagramFontDefinition");
            FontMetrics fontMetrics = FigureUtilities.getFontMetrics((Font)diagramFont);
            this.lineHeight = fontMetrics.getHeight();
            this.averageCharacterWidth = fontMetrics.getAverageCharacterWidth();
        }
    }
}

