/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.helpers.ArraySizeHelper;
import org.eclipse.fordiac.ide.model.helpers.VarDeclarationFactory;
import org.eclipse.fordiac.ide.model.libraryElement.ContainerVarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class ContainerVarDeclarationAnnotations {
    static VarDeclaration getCachedMember(ContainerVarDeclaration contVarDeclaration, List<String> path, boolean demandCreate) {
        VarDeclaration visibleMember = contVarDeclaration;
        int i = 0;
        while (i < path.size()) {
            if ((visibleMember = ContainerVarDeclarationAnnotations.getCachedMember(visibleMember, path.get(i), demandCreate)) == null || i != path.size() - 1 && !(visibleMember instanceof ContainerVarDeclaration)) {
                return null;
            }
            ++i;
        }
        return visibleMember;
    }

    private static VarDeclaration getCachedMember(ContainerVarDeclaration contVarDeclaration, String memberName, boolean demandCreate) {
        VarDeclaration visibleMember = contVarDeclaration.getCachedMember(memberName);
        if (visibleMember != null) {
            return visibleMember;
        }
        if (!demandCreate) {
            return null;
        }
        VarDeclaration memVar = ContainerVarDeclarationAnnotations.getMember(contVarDeclaration, memberName);
        if (memVar == null) {
            return null;
        }
        VarDeclaration newVisibleMember = VarDeclarationFactory.createVarDecl(memVar.getType());
        newVisibleMember.setName(memberName);
        newVisibleMember.setType(memVar.getType());
        ArraySizeHelper.setArraySize(newVisibleMember, ArraySizeHelper.getArraySize(memVar));
        newVisibleMember.setIsInput(contVarDeclaration.isIsInput());
        ContainerVarDeclarationAnnotations.insertNewVisibleMember(contVarDeclaration, newVisibleMember);
        if (newVisibleMember.isIsInput()) {
            newVisibleMember.setValue(LibraryElementFactory.eINSTANCE.createValue());
        }
        return newVisibleMember;
    }

    /*
     * WARNING - void declaration
     */
    private static VarDeclaration getMember(ContainerVarDeclaration structVarDeclarationImpl, String memberName) {
        void type;
        DataType dataType = structVarDeclarationImpl.getType();
        if (!(dataType instanceof StructuredType)) {
            return null;
        }
        StructuredType structuredType = (StructuredType)dataType;
        return type.getMemberVar(memberName);
    }

    private static void insertNewVisibleMember(ContainerVarDeclaration contVarDeclaration, VarDeclaration newVisibleMember) {
        StructuredType type;
        EList<VarDeclaration> typeMemVars;
        int pos;
        EList<VarDeclaration> cachedMembers = contVarDeclaration.getCachedMembers();
        DataType dataType = contVarDeclaration.getType();
        if (dataType instanceof StructuredType && (pos = Collections.binarySearch(cachedMembers, newVisibleMember, Comparator.comparingInt(arg_0 -> ContainerVarDeclarationAnnotations.lambda$0(typeMemVars = (type = (StructuredType)dataType).getMemberVariables(), arg_0)))) < 0) {
            pos = -(pos + 1);
            cachedMembers.add(pos, (Object)newVisibleMember);
            return;
        }
        cachedMembers.add((Object)newVisibleMember);
    }

    private static int findIndex(EList<VarDeclaration> memberVars, String varName) {
        int i = 0;
        while (i < memberVars.size()) {
            if (((VarDeclaration)memberVars.get(i)).getName().equals(varName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static TreeIterator<VarDeclaration> getAllCachedMembers(ContainerVarDeclaration contVarDeclaration) {
        return new AbstractTreeIterator<VarDeclaration>((Object)contVarDeclaration, false){
            private static final long serialVersionUID = 1L;

            public Iterator<VarDeclaration> getChildren(Object object) {
                if (object instanceof ContainerVarDeclaration) {
                    ContainerVarDeclaration container = (ContainerVarDeclaration)object;
                    return container.getCachedMembers().iterator();
                }
                return Collections.emptyIterator();
            }
        };
    }

    public static boolean validateMemberInputConnections(ContainerVarDeclaration contVarDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (contVarDeclaration.isIsInput() && !contVarDeclaration.getInputConnections().isEmpty() && ContainerVarDeclarationAnnotations.hasMemberInputConnection(contVarDeclaration)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 17, Messages.ContainerVarDeclarationAnnotations_MemberInputConnection, FordiacMarkerHelper.getDiagnosticData((EObject)contVarDeclaration, (EStructuralFeature)LibraryElementPackage.Literals.IINTERFACE_ELEMENT__INPUT_CONNECTIONS, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateMemberInitialValues(ContainerVarDeclaration contVarDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (contVarDeclaration.hasValue() && ContainerVarDeclarationAnnotations.hasMemberInitialValue(contVarDeclaration)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 18, Messages.ContainerVarDeclarationAnnotations_MemberInitialValue, FordiacMarkerHelper.getDiagnosticData((EObject)contVarDeclaration, new String[0])));
            }
            return false;
        }
        return true;
    }

    private static boolean hasMemberInputConnection(ContainerVarDeclaration contVarDeclaration) {
        TreeIterator<VarDeclaration> members = contVarDeclaration.getAllCachedMembers();
        while (members.hasNext()) {
            if (((VarDeclaration)members.next()).getInputConnections().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMemberInitialValue(ContainerVarDeclaration contVarDeclaration) {
        TreeIterator<VarDeclaration> members = contVarDeclaration.getAllCachedMembers();
        while (members.hasNext()) {
            if (!((VarDeclaration)members.next()).hasValue()) continue;
            return true;
        }
        return false;
    }

    private ContainerVarDeclarationAnnotations() {
        throw new UnsupportedOperationException("Helper class must not be instantiated");
    }

    private static /* synthetic */ int lambda$0(EList eList, VarDeclaration vm) {
        return ContainerVarDeclarationAnnotations.findIndex((EList<VarDeclaration>)eList, vm.getName());
    }
}

