/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.value;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.value.ValueConverter;

public final class StringValueConverter
implements ValueConverter<String> {
    public static final StringValueConverter INSTANCE = new StringValueConverter();
    private static final Pattern SCANNER_PATTERN = Pattern.compile("'(?:\\$'|[^'])*'");

    private StringValueConverter() {
    }

    @Override
    public String toValue(String string) throws IllegalArgumentException {
        int length = string.length();
        if (length < 2) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalStringLiteral, string));
        }
        char quote = string.charAt(0);
        if (quote != '\'') {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalStringLiteral, string));
        }
        if (string.charAt(length - 1) != '\'') {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_UnevenlyQuotedStringLiteral, string));
        }
        StringBuilder result = new StringBuilder(length - 2);
        int index = 1;
        while (index < length - 1) {
            char c = string.charAt(index);
            switch (c) {
                case '$': {
                    index = StringValueConverter.unescape(string, index + 1, result);
                    break;
                }
                case '\'': {
                    throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalStringLiteral, string));
                }
                default: {
                    result.append(c);
                    ++index;
                }
            }
        }
        return result.toString();
    }

    private static int unescape(CharSequence string, int index, StringBuilder result) {
        if (index >= string.length()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalEscapeInStringLiteral, string));
        }
        switch (string.charAt(index)) {
            case '$': {
                result.append('$');
                break;
            }
            case '\'': {
                result.append('\'');
                break;
            }
            case 'L': 
            case 'N': 
            case 'l': 
            case 'n': {
                result.append('\n');
                break;
            }
            case 'P': 
            case 'p': {
                result.append('\f');
                break;
            }
            case 'R': 
            case 'r': {
                result.append('\r');
                break;
            }
            case 'T': 
            case 't': {
                result.append('\t');
                break;
            }
            default: {
                return StringValueConverter.unescapeHexValue(string, index, result);
            }
        }
        return index + 1;
    }

    private static int unescapeHexValue(CharSequence string, int index, StringBuilder result) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        index = StringValueConverter.unescapeHexValue(string, index, stream);
        while (index < string.length() && string.charAt(index) == '$') {
            index = StringValueConverter.unescapeHexValue(string, index + 1, stream);
        }
        result.append(stream.toString(StandardCharsets.UTF_8));
        return index;
    }

    private static int unescapeHexValue(CharSequence string, int index, ByteArrayOutputStream stream) {
        if (index + 2 > string.length()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalEscapeInStringLiteral, string));
        }
        int digit1 = Character.digit(string.charAt(index), 16);
        int digit2 = Character.digit(string.charAt(index + 1), 16);
        if (digit1 < 0 || digit2 < 0) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalEscapeInStringLiteral, string));
        }
        stream.write(digit1 << 4 | digit2);
        return index + 2;
    }

    @Override
    public String toValue(Scanner scanner) throws IllegalArgumentException, NoSuchElementException, IllegalStateException {
        return (String)this.toValue(scanner, SCANNER_PATTERN);
    }

    @Override
    public String toString(String value) {
        int length = value.length();
        StringBuilder result = new StringBuilder(length + 2);
        result.append('\'');
        value.codePoints().forEachOrdered(c -> StringValueConverter.escape(c, result));
        result.append('\'');
        return result.toString();
    }

    private static void escape(int value, StringBuilder result) {
        switch (value) {
            case 36: {
                result.append("$$");
                break;
            }
            case 39: {
                result.append("$'");
                break;
            }
            case 10: {
                result.append("$L");
                break;
            }
            case 12: {
                result.append("$P");
                break;
            }
            case 13: {
                result.append("$R");
                break;
            }
            case 9: {
                result.append("$T");
                break;
            }
            default: {
                if (value >= 32 && value <= 126) {
                    result.append((char)value);
                    break;
                }
                StringValueConverter.escapeHexValue(value, result);
            }
        }
    }

    private static void escapeHexValue(int value, StringBuilder result) {
        byte[] bytes;
        byte[] byArray = bytes = Character.toString(value).getBytes(StandardCharsets.UTF_8);
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            result.append(String.format("$%02X", b));
            ++n2;
        }
    }
}

