/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.formatting2;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.xtext.formatting2.FormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.preferences.TypedPreferenceKey;

public final class FormatterUtil {
    public static final Pattern NEWLINE_PATTERN = Pattern.compile("\\R");

    public static int getIndendationChars(ITextReplacerContext context) {
        String indentation = (String)context.getFormatter().getPreference((TypedPreferenceKey)FormatterPreferenceKeys.indentation);
        if ("\t".equals(indentation)) {
            return (Integer)context.getFormatter().getPreference((TypedPreferenceKey)FormatterPreferenceKeys.tabWidth) * context.getIndentation();
        }
        return indentation.length() * context.getIndentation();
    }

    public static String wrapLines(String lines, int wrapLength, String lineSeparator) {
        Matcher matcher = Pattern.compile("(.{0," + wrapLength + "})(?:\\s|$)").matcher(lines);
        StringBuilder result = new StringBuilder(lines.length() + 4);
        int last = 0;
        while (matcher.find()) {
            result.append(lines, last, matcher.start());
            if (matcher.end() > matcher.start()) {
                result.append(lines, matcher.start(1), matcher.end(1));
                result.append(lineSeparator);
            }
            last = matcher.end();
        }
        result.append(lines, last, lines.length());
        return result.toString();
    }

    public static String prefixLines(String lines, String prefix, String lineSeparator) {
        if (lines.isEmpty()) {
            return prefix;
        }
        return lines.lines().map(line -> line.isEmpty() ? prefix + line : prefix + " " + line).collect(Collectors.joining(lineSeparator));
    }

    public static void configureCommentWhitespace(IHiddenRegionFormatting leading, IHiddenRegionFormatting trailing) {
        if (trailing.getIndentationIncrease() != null) {
            leading.setIndentationIncrease(FormatterUtil.merge(leading.getIndentationIncrease(), trailing.getIndentationIncrease()));
            trailing.setIndentationIncrease(null);
        }
        if (leading.getIndentationDecrease() != null) {
            trailing.setIndentationDecrease(FormatterUtil.merge(leading.getIndentationDecrease(), trailing.getIndentationDecrease()));
            leading.setIndentationDecrease(null);
        }
    }

    private static Integer merge(Integer value1, Integer value2) {
        if (value1 != null && value2 != null) {
            return value1 + value2;
        }
        return value1 != null ? value1 : value2;
    }

    private FormatterUtil() {
        throw new UnsupportedOperationException();
    }
}

